/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.common;

import co.adcel.common.IAdProviderDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AdProviderDTO
implements IAdProviderDTO {
    private String providerId;
    private String providerName;
    private String appId;
    private int appIdInt;
    private String appKey;
    private String ecpm;
    private String weight;
    private int maxShows = 0;
    private int inactiveTimeout = 0;
    private int showCount = 0;
    private long lastShowTime = 0L;
    private String options = null;
    private List<BannerSize> sizes = new ArrayList<BannerSize>();
    private Map<String, String> zones = new HashMap<String, String>();

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public String getProviderWeight() {
        return this.weight;
    }

    @Override
    public String getProviderECPM() {
        return this.ecpm;
    }

    @Override
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    @Override
    public void setProviderWeight(String weight) {
        this.weight = weight;
    }

    @Override
    public void setProviderECPM(String ecpm) {
        this.ecpm = ecpm;
    }

    @Override
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    public void setAppIdInt(int appIdInt) {
        this.appIdInt = appIdInt;
    }

    public int getAppIdInt() {
        return this.appIdInt;
    }

    @Override
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    @Override
    public String getAppKey() {
        return this.appKey;
    }

    public int getMaxShows() {
        return this.maxShows;
    }

    public void setMaxShows(int maxShows) {
        this.maxShows = maxShows;
    }

    public int getInactiveTimeout() {
        return this.inactiveTimeout;
    }

    public void setInactiveTimeout(int inactiveTimeout) {
        this.inactiveTimeout = inactiveTimeout;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public Map<String, String> getZones() {
        return this.zones;
    }

    public String getZone(String zone) {
        if (zone == null) {
            return null;
        }
        return this.zones.get(zone);
    }

    public void incShow() {
        ++this.showCount;
        this.lastShowTime = new Date().getTime() / 1000L;
    }

    public boolean shouldShow() {
        if (this.maxShows == 0 || this.inactiveTimeout == 0) {
            return true;
        }
        if (this.showCount < this.maxShows) {
            return true;
        }
        long time = new Date().getTime() / 1000L;
        if (time - this.lastShowTime >= (long)this.inactiveTimeout) {
            this.showCount = 0;
            return true;
        }
        return false;
    }

    public void resetBan() {
        this.showCount = 0;
    }

    public void addSize(int width, int height, String appId, String appKey) {
        BannerSize bs = new BannerSize();
        bs.width = width;
        bs.height = height;
        bs.appId = appId;
        bs.appKey = appKey;
        int idx = this.sizes.size();
        if (idx > 0) {
            BannerSize bsz = this.sizes.get(0);
            if (bs.width > bsz.width) {
                idx = 0;
            }
        }
        this.sizes.add(idx, bs);
    }

    public BannerSize getBannerForSize(int width, int height) {
        BannerSize bs = new BannerSize();
        bs.width = width;
        bs.height = height;
        bs.appId = this.getAppId();
        bs.appKey = this.getAppKey();
        if (width <= 0 && height <= 0) {
            return bs;
        }
        for (BannerSize bsz : this.sizes) {
            if (width < bsz.width && width > 0 || height < bsz.height && height > 0) continue;
            return bsz;
        }
        return bs;
    }

    public static class BannerSize {
        int width;
        int height;
        String appId;
        String appKey;

        public String getAppId() {
            return this.appId;
        }

        public String getAppKey() {
            return this.appKey;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

