/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.common;

import android.content.Context;
import co.adcel.common.Utilities;
import co.adcel.logger.AdsATALog;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class DexLibLoader {
    private static String optimizedDirectory = "optimized";
    private static String workDirectory = "working";

    public static void loadFromAssets(Context context, String assetFolder, String fileName) throws Exception {
        File optimized = new File(optimizedDirectory);
        optimized = context.getDir(optimized.toString(), 0);
        optimized = new File(optimized, fileName);
        optimized.mkdir();
        File work = context.getDir(workDirectory, 0);
        work = new File(work, fileName);
        String dexVer = Utilities.readStringLocalData(context, fileName);
        if (!work.exists() || work.length() == 0L || !dexVer.equals("1.12.4")) {
            int r;
            InputStream inputDex = context.getAssets().open(assetFolder + "/" + fileName);
            FileOutputStream outputDex = new FileOutputStream(work);
            byte[] buf = new byte[4096];
            while ((r = inputDex.read(buf)) != -1) {
                outputDex.write(buf, 0, r);
            }
            outputDex.close();
            inputDex.close();
            AdsATALog.d(fileName + " has copied to work dir");
        }
        if (work.exists() && work.length() > 0L) {
            Utilities.saveStringLocalData(context, fileName, "1.12.4");
            try {
                ClassLoader localClassLoader = DexLibLoader.class.getClassLoader();
                DexClassLoader classLoader = new DexClassLoader(work.getAbsolutePath(), optimized.getAbsolutePath(), null, localClassLoader);
                if (!(localClassLoader instanceof BaseDexClassLoader)) {
                    throw new UnsupportedOperationException("Class loader not supported");
                }
                Object existing = DexLibLoader.getDexClassLoaderElements((BaseDexClassLoader)localClassLoader);
                Object incoming = DexLibLoader.getDexClassLoaderElements((BaseDexClassLoader)classLoader);
                Object joined = DexLibLoader.joinArrays(incoming, existing);
                DexLibLoader.setDexClassLoaderElements((BaseDexClassLoader)localClassLoader, joined);
            }
            catch (IOException e) {
                throw new Exception("unable load DexClassLoader");
            }
        } else {
            throw new Exception("dex file doesn't copy");
        }
    }

    private static void setDexClassLoaderElements(BaseDexClassLoader classLoader, Object elements) throws Exception {
        Class<BaseDexClassLoader> dexClassLoaderClass = BaseDexClassLoader.class;
        Field pathListField = dexClassLoaderClass.getDeclaredField("pathList");
        pathListField.setAccessible(true);
        Object pathList = pathListField.get(classLoader);
        Field dexElementsField = pathList.getClass().getDeclaredField("dexElements");
        dexElementsField.setAccessible(true);
        dexElementsField.set(pathList, elements);
    }

    private static Object getDexClassLoaderElements(BaseDexClassLoader classLoader) throws Exception {
        Class<BaseDexClassLoader> dexClassLoaderClass = BaseDexClassLoader.class;
        Field pathListField = dexClassLoaderClass.getDeclaredField("pathList");
        pathListField.setAccessible(true);
        Object pathList = pathListField.get(classLoader);
        Field dexElementsField = pathList.getClass().getDeclaredField("dexElements");
        dexElementsField.setAccessible(true);
        Object dexElements = dexElementsField.get(pathList);
        return dexElements;
    }

    private static Object joinArrays(Object o1, Object o2) {
        Class<?> o2Type;
        Class<?> o1Type = o1.getClass().getComponentType();
        if (o1Type != (o2Type = o2.getClass().getComponentType())) {
            throw new IllegalArgumentException();
        }
        int o1Size = Array.getLength(o1);
        int o2Size = Array.getLength(o2);
        Object array = Array.newInstance(o1Type, o1Size + o2Size);
        int offset = 0;
        int i = 0;
        while (i < o1Size) {
            Array.set(array, offset, Array.get(o1, i));
            ++i;
            ++offset;
        }
        i = 0;
        while (i < o2Size) {
            Array.set(array, offset, Array.get(o2, i));
            ++i;
            ++offset;
        }
        return array;
    }
}

