/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.common;

import co.adcel.ads.mediation.AdFormat;
import java.util.ArrayList;

public class TypeConverter {
    public static int getMaskForType(String type) {
        switch (type) {
            case "audio": {
                return 64;
            }
            case "banner": {
                return 32;
            }
            case "image": {
                return 1;
            }
            case "interstitial": {
                return 4;
            }
            case "native": {
                return 16;
            }
            case "reward": {
                return 8;
            }
            case "video": {
                return 2;
            }
        }
        return 0;
    }

    public static int getMaskFromTypes(String ... types) {
        int adTypeMask = 0;
        for (String type : types) {
            adTypeMask |= TypeConverter.getMaskForType(type);
        }
        return adTypeMask;
    }

    public static String[] getTypesFromMask(int adTypeMask) {
        ArrayList<String> types = new ArrayList<String>();
        if ((adTypeMask & 1) == 1) {
            types.add("image");
        }
        if ((adTypeMask & 2) == 2) {
            types.add("video");
        }
        if ((adTypeMask & 4) == 4) {
            types.add("interstitial");
        }
        if ((adTypeMask & 8) == 8) {
            types.add("reward");
        }
        if ((adTypeMask & 0x20) == 32) {
            types.add("banner");
        }
        if ((adTypeMask & 0x10) == 16) {
            types.add("native");
        }
        if ((adTypeMask & 0x40) == 64) {
            types.add("audio");
        }
        return types.toArray(new String[0]);
    }

    public static AdFormat[] getAdTypeListFromMask(int adTypeMask) {
        ArrayList<AdFormat> types = new ArrayList<AdFormat>();
        if ((adTypeMask & 1) == 1) {
            types.add(AdFormat.IMAGE);
        }
        if ((adTypeMask & 2) == 2) {
            types.add(AdFormat.VIDEO);
        }
        if ((adTypeMask & 4) == 4) {
            types.add(AdFormat.INTERSTITIAL);
        }
        if ((adTypeMask & 8) == 8) {
            types.add(AdFormat.REWARDED);
        }
        if ((adTypeMask & 0x20) == 32) {
            types.add(AdFormat.BANNER);
        }
        if ((adTypeMask & 0x10) == 16) {
            types.add(AdFormat.NATIVE);
        }
        if ((adTypeMask & 0x40) == 64) {
            types.add(AdFormat.AUDIO);
        }
        return types.toArray(new AdFormat[0]);
    }
}

