/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.common;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.telephony.TelephonyManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.common.AppPackageName;
import co.adcel.common.DexLibLoader;
import co.adcel.logger.AdsATALog;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Utilities {
    static SharedPreferences sp;
    static SharedPreferences.Editor sed;
    static boolean onResumeCalled;

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null;
    }

    public static boolean isConnectedMobile(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        return info != null && info.isConnected() && info.getType() == 0;
    }

    public static boolean isConnectedWifi(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        return info != null && info.isConnected() && info.getType() == 1;
    }

    private static SharedPreferences getSharedPreferences(Context context) {
        if (sp == null) {
            sp = context.getApplicationContext().getSharedPreferences("provider_params_data", 0);
        }
        return sp;
    }

    public static void saveStringLocalData(Context context, String name, String value) {
        if (sed == null) {
            sed = Utilities.getSharedPreferences(context).edit();
        }
        if (value == null) {
            sed.remove(name);
        } else {
            sed.putString(name, value);
        }
        sed.commit();
    }

    public static String readStringLocalData(Context context, String name) {
        return Utilities.getSharedPreferences(context).getString(name, "");
    }

    public static void saveOpenDate(Context context, String timestamp) {
        Utilities.saveStringLocalData(context, "open_date", timestamp);
    }

    public static Date getOpenDate2(Context context) {
        String openDate = Utilities.getOpenDate(context);
        if (openDate == null || openDate.length() == 0) {
            Date date = new Date();
            long seconds = date.getTime() / 1000L;
            openDate = String.valueOf(Math.round(seconds));
            Utilities.saveOpenDate(context, openDate);
            return date;
        }
        try {
            long timestamp = Long.parseLong(openDate);
            long time = timestamp * 1000L;
            return new Date(time);
        }
        catch (Throwable e) {
            Date date = new Date();
            long seconds = date.getTime() / 1000L;
            openDate = String.valueOf(Math.round(seconds));
            Utilities.saveOpenDate(context, openDate);
            return date;
        }
    }

    public static String getOpenDate(Context context) {
        return Utilities.readStringLocalData(context, "open_date");
    }

    public static String getInHouseClickId(Context context) {
        try {
            Uri uri = Uri.parse((String)String.format("content://%s.%s/%s/%s", context.getPackageName(), "co.adcel.inhouse.tracking", "apps", context.getPackageName()));
            Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    String clickId = cursor.getString(cursor.getColumnIndex("click_id"));
                    cursor.close();
                    return clickId;
                }
                cursor.close();
            }
        }
        catch (SecurityException e) {
            AdsATALog.e("Unnable to getInHouseClickId", e);
        }
        catch (Exception e) {
            AdsATALog.e("Unnable to getInHouseClickId", e);
        }
        String clickId = Utilities.readStringLocalData(context, "click_id");
        if (clickId != null && clickId.length() > 0) {
            return clickId;
        }
        return "";
    }

    public static void saveInHouseClickId(Context context, String clickId) {
        Utilities.saveStringLocalData(context, "click_id", clickId);
    }

    public static void saveInHouseClickId(Context context, String storeId, String clickId) {
        Uri uri = Uri.parse((String)String.format("content://%s.%s/%s/%s", context.getPackageName(), "co.adcel.inhouse.tracking", "apps", storeId));
        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
        if (cursor != null) {
            if (cursor.getCount() != 0) {
                context.getContentResolver().delete(uri, null, null);
            }
            cursor.close();
        }
        if (!Utilities.isInstallAppWithBundleId(context, storeId).booleanValue()) {
            ContentValues values = new ContentValues();
            values.put("store_id", storeId);
            values.put("click_id", clickId);
            context.getContentResolver().insert(Uri.parse((String)String.format("content://%s.%s/%s", context.getPackageName(), "co.adcel.inhouse.tracking", "apps")), values);
        }
    }

    private static Boolean isInstallAppWithBundleId(Context context, String storeId) {
        List packages = context.getPackageManager().getInstalledApplications(128);
        for (ApplicationInfo packageInfo : packages) {
            String appName = packageInfo.packageName;
            if (!storeId.equals(appName)) continue;
            return true;
        }
        return false;
    }

    public static void findAndRemoveInHouseClickId(Context context) {
        Uri uri = Uri.parse((String)String.format("content://%s.%s/%s/%s", context.getPackageName(), "co.adcel.inhouse.tracking", "apps", context.getPackageName()));
        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
        if (cursor != null) {
            if (cursor.getCount() != 0) {
                context.getContentResolver().delete(uri, null, null);
            }
            cursor.close();
        }
        Utilities.saveInHouseClickId(context, null);
    }

    public static boolean isTablet(Context ctx) {
        boolean isTablet = false;
        try {
            isTablet = (ctx.getResources().getConfiguration().screenLayout & 0xF) >= 3;
            AdsATALog.i(String.format("Check device screen size configuration. IsTablet: %s", isTablet));
        }
        catch (Exception e) {
            AdsATALog.i("Error check device screen size configuration!");
        }
        return isTablet;
    }

    public static boolean tryParseInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static synchronized String getInstalledProvidersJson(Context context) {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        jsonArray.put(40);
        HashMap<Integer, String> providersMap = new HashMap<Integer, String>();
        providersMap.put(1, "com.adcolony.sdk.AdColony");
        providersMap.put(3, "com.smaato.soma.AdSettings");
        providersMap.put(5, "com.startapp.sdk.adsbase.StartAppSDK");
        providersMap.put(6, "com.inmobi.sdk.InMobiSdk");
        providersMap.put(7, "com.google.android.gms.ads.MobileAds");
        providersMap.put(8, "com.applovin.sdk.AppLovinSdk");
        providersMap.put(16, "com.amazon.device.ads.AdRegistration");
        providersMap.put(17, "com.vungle.warren.Vungle");
        providersMap.put(21, "com.my.target.ads.InterstitialAd");
        providersMap.put(22, "com.unity3d.ads.UnityAds");
        providersMap.put(24, "com.nativex.monetization.MonetizationManager");
        providersMap.put(26, "com.yandex.mobile.ads.MobileAds");
        providersMap.put(27, "com.ironsource.mediationsdk.IronSource");
        providersMap.put(15, "com.tapjoy.Tapjoy");
        providersMap.put(31, "com.facebook.ads.Ad");
        providersMap.put(30, "co.adcel.inhouse.InHouseAdsManager");
        providersMap.put(18, "com.mopub.common.MoPub");
        providersMap.put(38, "io.presage.Presage");
        providersMap.put(43, "com.criteo.publisher.Criteo");
        providersMap.put(42, "com.bytedance.sdk.openadsdk.TTAdSdk");
        Object[] dexs = null;
        try {
            dexs = context.getAssets().list("dex");
            AdsATALog.d("dex from assets: " + Arrays.toString(dexs));
        }
        catch (IOException e) {
            AdsATALog.e("dex from assets error: " + e.getMessage(), e);
        }
        Iterator e = providersMap.keySet().iterator();
        block22: while (e.hasNext()) {
            int key = (Integer)e.next();
            String className = (String)providersMap.get(key);
            try {
                Class.forName(className);
                jsonArray.put(key);
            }
            catch (ClassNotFoundException e2) {
                if (dexs == null || dexs.length <= 0) continue;
                String dexName = null;
                switch (key) {
                    case 1: {
                        dexName = "adcolony.dex";
                        break;
                    }
                    case 3: {
                        dexName = "smaato.dex";
                        break;
                    }
                    case 5: {
                        dexName = "startapp.dex";
                        break;
                    }
                    case 8: {
                        dexName = "applovin.dex";
                        break;
                    }
                    case 15: {
                        dexName = "tapjoy.dex";
                        break;
                    }
                    case 16: {
                        dexName = "amazon.dex";
                        break;
                    }
                    case 17: {
                        dexName = "vungle.dex";
                        break;
                    }
                    case 21: {
                        dexName = "mytarget.dex";
                        break;
                    }
                    case 22: {
                        dexName = "unity.dex";
                        break;
                    }
                    case 24: {
                        dexName = "nativex.dex";
                        break;
                    }
                    case 26: {
                        dexName = "yandex.dex";
                        break;
                    }
                    case 27: {
                        dexName = "supersonic.dex";
                    }
                }
                if (dexName == null || dexs == null || dexs.length <= 0) continue;
                for (Object dex : dexs) {
                    if (!((String)dex).equals(dexName)) continue;
                    try {
                        DexLibLoader.loadFromAssets(context, "dex", (String)dex);
                    }
                    catch (Exception ex) {
                        AdsATALog.i("Unable to load DEX file " + (String)dex + ", error: " + e2.getMessage(), e2);
                    }
                    jsonArray.put(key);
                    continue block22;
                }
            }
        }
        try {
            jsonObject.put("providers", (Object)jsonArray);
            AdsATALog.d("Installed providers libs: " + jsonArray.toString());
        }
        catch (JSONException e2) {
            AdsATALog.e("failed to send providers: " + e2.getMessage(), e2);
        }
        return jsonObject.toString();
    }

    public static void onResume() {
        onResumeCalled = true;
    }

    public static boolean checkActivityLifeCycleSync() {
        if (!onResumeCalled) {
            AdsATALog.i("==========\n\tThe AdCel SDK needs to be notified of changes in the activity lifecycle so it can keep track of the current activity. This can be easily achieved by calling the onPause(Activity), onResume(Activity) and onDestroy(Activity) methods.\n==========");
        }
        return onResumeCalled;
    }

    public static String getAppPackageName(Context context) {
        if (AppPackageName.value != null) {
            return AppPackageName.value;
        }
        return context.getApplicationContext().getPackageName();
    }

    @Nullable
    public static String getNetworkOperatorName(@NonNull Context context) {
        int hasPerm;
        PackageManager pm;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        try {
            pm = context.getPackageManager();
        }
        catch (Throwable ignored) {
            return null;
        }
        if (pm != null && (hasPerm = pm.checkPermission("android.permission.READ_PHONE_STATE", context.getPackageName())) == 0) {
            String networkOperatorName = telephonyManager.getSimOperatorName();
            networkOperatorName = networkOperatorName == null || networkOperatorName.length() == 0 ? telephonyManager.getSimOperatorName() : networkOperatorName;
            return networkOperatorName;
        }
        return null;
    }

    @Nullable
    public static String getRtbConnectionType(Context context) {
        PackageManager pm;
        try {
            pm = context.getPackageManager();
        }
        catch (Throwable ignored) {
            return null;
        }
        if (pm == null) {
            return null;
        }
        String packageName = context.getApplicationContext().getPackageName();
        int hasPerm = pm.checkPermission("android.permission.ACCESS_NETWORK_STATE", packageName);
        if (hasPerm != 0) {
            return null;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info == null) {
            return null;
        }
        return Utilities.getRtbConnectionType(info);
    }

    private static String getRtbConnectionType(NetworkInfo info) {
        switch (info.getType()) {
            case 1: {
                return "2";
            }
            case 0: {
                return Utilities.getRtbMobileConnectionType(info.getSubtype());
            }
        }
        return "0";
    }

    private static String getRtbMobileConnectionType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return "4";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return "5";
            }
            case 13: {
                return "6";
            }
        }
        return "3";
    }

    public static boolean checkBasePermissions(@NonNull Activity activity) {
        String packageName = activity.getApplicationContext().getPackageName();
        PackageManager pm = null;
        try {
            pm = activity.getPackageManager();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (pm == null) {
            return false;
        }
        int hasPerm = pm.checkPermission("android.permission.INTERNET", packageName);
        if (hasPerm != 0) {
            AdsATALog.e("!!!!!!!!!!!!!! NO INTERNET PERMISSION !!!!!!!!!!!!!!!!");
            return false;
        }
        hasPerm = pm.checkPermission("android.permission.ACCESS_NETWORK_STATE", packageName);
        if (hasPerm != 0) {
            AdsATALog.e("!!!!!!!!!!!!!! NO ACCESS_NETWORK_STATE PERMISSION !!!!!!!!!!!!!!!!");
            return false;
        }
        return true;
    }

    static {
        onResumeCalled = false;
    }

    public static class TestAdsData {
        public static final String STATE_SDKNONINITIALIZED = "AdCel SDK is not initialized.";
        public static final String STATE_SDKINITIALIZED_NONMODERATE = "AdCel SDK successfully initialized. Your application to moderation.";
        public static final String STATE_SDKINITIALIZED_MODERATE = "AdCel SDK successfully initialized. Your application has been successfully moderated. You can disable the test mode.";
        public static final String COLOR_SDKNONINITIALIZED = "#FF0000";
        public static final String COLOR_SDKINITIALIZED_NONMODERATE = "#FFFF00";
        public static final String COLOR_SDKINITIALIZED_MODERATE = "#00FF00";
    }
}

