/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.http;

import co.adcel.http.Callback;
import co.adcel.http.Error;
import co.adcel.http.HttpClient;
import co.adcel.http.Request;
import co.adcel.http.Response;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SimpleHttpClient
implements HttpClient {
    private ExecutorService executorService;

    @Override
    public Response executeSync(Request request) throws IOException {
        return this.execute(request);
    }

    private ExecutorService getDefaultExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        return this.executorService;
    }

    @Override
    public void executeAsync(Request request) {
        this.executeAsync(request, null);
    }

    @Override
    public void executeAsync(Request request, Callback callback) {
        this.executeAsync(request, callback, this.getDefaultExecutorService());
    }

    @Override
    public void executeAsync(final Request request, final Callback callback, ExecutorService executorService) {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                SimpleHttpClient.this.executeSync(request, callback);
            }
        });
    }

    private void executeSync(Request request, Callback callback) {
        block3: {
            try {
                Response response = this.executeSync(request);
                if (callback != null) {
                    callback.onSuccess(response);
                }
            }
            catch (IOException e) {
                if (callback == null) break block3;
                callback.onError(new Error(e, e.getMessage()));
            }
        }
    }

    private HttpURLConnection prepareConnection(String method, String url) throws IOException {
        URL urlInstance = new URL(url);
        HttpURLConnection urlConnection = (HttpURLConnection)urlInstance.openConnection();
        urlConnection.setRequestMethod(method);
        return urlConnection;
    }

    private void prepareHeaders(HttpURLConnection urlConnection, Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            urlConnection.setRequestProperty(header.getKey(), header.getValue());
        }
    }

    private void prepareBody(HttpURLConnection urlConnection, String body) {
        if (body == null) {
            return;
        }
        urlConnection.setDoOutput(true);
        try (OutputStreamWriter out = new OutputStreamWriter(urlConnection.getOutputStream());){
            out.write(body);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getStringFromStream(InputStream inStream) {
        StringBuilder responseText = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));){
            String inputLine;
            while ((inputLine = reader.readLine()) != null) {
                responseText.append(inputLine);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return responseText.toString();
    }

    private Response processResponse(HttpURLConnection urlConnection) throws IOException {
        int responseCode = urlConnection.getResponseCode();
        String responseString = null;
        if (responseCode >= 200 && responseCode < 400) {
            BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
            responseString = this.getStringFromStream(in);
        }
        return new Response(responseCode, responseString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response execute(Request request) throws IOException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.prepareConnection(request.getMethod().name(), request.getUrl());
            this.prepareHeaders(urlConnection, request.getHeaders());
            this.prepareBody(urlConnection, request.getBody());
            Response response = this.processResponse(urlConnection);
            return response;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }
}

