/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.inhouse;

import co.adcel.http.HttpClient;
import co.adcel.http.Request;
import co.adcel.http.SimpleHttpClient;
import co.adcel.toolkit.JSONObjectExt;
import org.json.JSONObject;

public class Ad {
    private String clickUrl;
    private String impressUrl;
    private String storeCountry;
    private String storeId;
    private String clickId;
    private Static aStatic = null;
    private Video video = null;
    private HttpClient httpClient;

    public static Ad get(JSONObject jsonObject) {
        return new Ad(jsonObject);
    }

    Ad(JSONObject jsonObject) {
        if (jsonObject == null) {
            throw new IllegalArgumentException();
        }
        this.clickUrl = JSONObjectExt.optString(jsonObject, "click_url");
        this.impressUrl = JSONObjectExt.optString(jsonObject, "impress_url");
        this.storeCountry = JSONObjectExt.optString(jsonObject, "store_country");
        this.storeId = JSONObjectExt.optString(jsonObject, "store_id");
        this.clickId = JSONObjectExt.optString(jsonObject, "click_id");
        JSONObject typeJsonObj = jsonObject.optJSONObject("static");
        if (typeJsonObj != null) {
            this.aStatic = new Static(typeJsonObj);
        }
        if ((typeJsonObj = jsonObject.optJSONObject("video")) != null) {
            this.video = new Video(typeJsonObj);
        }
        this.httpClient = new SimpleHttpClient();
    }

    public String getClickUrl() {
        return this.clickUrl;
    }

    public String getImpressUrl() {
        return this.impressUrl;
    }

    public String getStoreCountry() {
        return this.storeCountry;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getClickId() {
        return this.clickId;
    }

    public Static getStatic() {
        return this.aStatic;
    }

    public Video getVideo() {
        return this.video;
    }

    public void registerImpression() {
        if (this.getImpressUrl() != null && this.getImpressUrl().length() != 0) {
            this.registerAction(this.getImpressUrl());
        }
    }

    public void registerClick() {
        if (this.getClickUrl() != null && this.getClickUrl().length() != 0) {
            this.registerAction(this.getClickUrl());
        }
    }

    private void registerAction(String url) {
        this.httpClient.executeAsync(new Request.Builder(url).build());
    }

    public static class Video {
        private boolean streamable;
        private boolean cacheable;
        private String download;
        private boolean shouldCache;
        private int size;
        private String streaming;
        private String orientation;
        private int skipTimer;

        Video(JSONObject jsonObject) {
            if (jsonObject != null) {
                this.streamable = jsonObject.optBoolean("streamable");
                this.cacheable = jsonObject.optBoolean("cacheable");
                this.download = JSONObjectExt.optString(jsonObject, "download");
                this.shouldCache = jsonObject.optBoolean("should_cache");
                this.size = jsonObject.optInt("size");
                this.streaming = JSONObjectExt.optString(jsonObject, "streaming");
                this.orientation = JSONObjectExt.optString(jsonObject, "orientation");
                this.skipTimer = jsonObject.optInt("skip_timer", 5);
            }
        }

        public boolean isStreamable() {
            return this.streamable;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public String getDownload() {
            return this.download;
        }

        public boolean isShouldCache() {
            return this.shouldCache;
        }

        public int getSize() {
            return this.size;
        }

        public String getStreaming() {
            return this.streaming;
        }

        public String getOrientation() {
            return this.orientation;
        }

        public int getSkipTimer() {
            return this.skipTimer;
        }
    }

    public static class Static {
        private String cta;
        private String imagePortrait;
        private String imageLandscape;
        private String orientation;

        Static(JSONObject jsonObject) {
            if (jsonObject != null) {
                this.cta = JSONObjectExt.optString(jsonObject, "cta");
                this.imagePortrait = JSONObjectExt.optString(jsonObject, "image_p");
                this.imageLandscape = JSONObjectExt.optString(jsonObject, "image_l");
                this.orientation = JSONObjectExt.optString(jsonObject, "orientation");
            }
        }

        public String getCta() {
            return this.cta;
        }

        public String getImagePortrait() {
            return this.imagePortrait;
        }

        public String getImageLandscape() {
            return this.imageLandscape;
        }

        public String getOrientation() {
            return this.orientation;
        }
    }
}

