/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.inhouse;

import android.app.Activity;
import android.content.Context;
import co.adcel.ads.base.SdkPlugin;
import co.adcel.ads.inhouse.InHouseWebService;
import co.adcel.inhouse.DependencyFactory;
import co.adcel.inhouse.InHouseInitializer;
import co.adcel.init.AdCel;

public class AdCelInHouse {
    private static AdCelInHouse mInHouseInstance;
    private InHouseInitializer mInHouseInitializer;
    private String mSdkKey = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AdCelInHouse getInstance() {
        AdCelInHouse localInstance = mInHouseInstance;
        if (localInstance != null) return localInstance;
        Class<AdCelInHouse> clazz = AdCelInHouse.class;
        synchronized (AdCelInHouse.class) {
            localInstance = mInHouseInstance;
            if (localInstance != null) return localInstance;
            mInHouseInstance = localInstance = new AdCelInHouse();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localInstance;
        }
    }

    public static void initializeSDK(Activity activity, String sdkKey, int adTypeMask, boolean gdprConsent) {
        AdCelInHouse.getInstance().initialize(activity, sdkKey, adTypeMask, gdprConsent);
    }

    private void initialize(Activity activity, String sdkKey, int adTypeMask, boolean gdprConsent) {
        DependencyFactory dependencyFactory;
        InHouseWebService inHouseWebService;
        SdkPlugin sdkPlugin = null;
        String adCelPluginName = AdCel.pluginName();
        if (adCelPluginName != null) {
            sdkPlugin = SdkPlugin.fromName(adCelPluginName);
        }
        if ((inHouseWebService = (dependencyFactory = new DependencyFactory((Context)activity, sdkKey, sdkPlugin)).getInHouseWebService()) == null) {
            throw new IllegalStateException("SDK initialized incorrectly");
        }
        this.mInHouseInitializer = new InHouseInitializer(this, inHouseWebService);
        this.setSdkKey(sdkKey);
        this.mInHouseInitializer.initializeSDK(activity, sdkKey, adTypeMask, gdprConsent);
    }

    public static void refreshSettings(Activity activity, int adTypeMask, boolean gdprConsent) {
        if (AdCelInHouse.getInstance().getSdkKey().length() == 0) {
            throw new IllegalArgumentException("AdCelSdkKey can't be null");
        }
        if (AdCelInHouse.getInstance().mInHouseInitializer == null) {
            throw new IllegalStateException("mInHouseInitializer is not initialized");
        }
        AdCelInHouse.getInstance().mInHouseInitializer.initializeSDK(activity, AdCelInHouse.getInstance().getSdkKey(), adTypeMask, gdprConsent);
    }

    private AdCelInHouse() {
    }

    public String getSdkKey() {
        return this.mSdkKey;
    }

    public void setSdkKey(String sdkKey) {
        this.mSdkKey = sdkKey;
    }
}

