/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.inhouse;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.ads.base.AdIdService;
import co.adcel.ads.base.AndroidAdIdService;
import co.adcel.ads.base.DefaultSdkConfigProvider;
import co.adcel.ads.base.SdkConfigProvider;
import co.adcel.ads.base.SdkPlugin;
import co.adcel.ads.inhouse.DefaultInHouseWebService;
import co.adcel.ads.inhouse.InHouseWebService;
import co.adcel.http.HttpClient;
import co.adcel.http.SimpleHttpClient;

public class DependencyFactory {
    @NonNull
    private final Context context;
    @NonNull
    private final String key;
    @Nullable
    private final SdkPlugin sdkPlugin;
    private volatile AdIdService adIdService;
    private volatile HttpClient httpClient;
    private volatile SdkConfigProvider sdkConfigProvider;
    private volatile InHouseWebService inHouseWebService;

    DependencyFactory(@NonNull Context context, @NonNull String key, @Nullable SdkPlugin sdkPlugin) {
        this.context = context;
        this.key = key;
        this.sdkPlugin = sdkPlugin;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public SdkPlugin getSdkPlugin() {
        return this.sdkPlugin;
    }

    @NonNull
    public AdIdService getAdIdService() {
        if (this.adIdService == null) {
            this.adIdService = new AndroidAdIdService(this.getContext());
        }
        return this.adIdService;
    }

    @NonNull
    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new SimpleHttpClient();
        }
        return this.httpClient;
    }

    @NonNull
    public SdkConfigProvider getSdkConfigProvider() {
        if (this.sdkConfigProvider == null) {
            this.sdkConfigProvider = new DefaultSdkConfigProvider(this.getContext(), this.getKey(), this.getSdkPlugin(), this.getAdIdService());
        }
        return this.sdkConfigProvider;
    }

    @NonNull
    public InHouseWebService getInHouseWebService() {
        if (this.inHouseWebService == null) {
            this.inHouseWebService = new DefaultInHouseWebService(this.getHttpClient(), this.getSdkConfigProvider());
        }
        return this.inHouseWebService;
    }
}

