/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.inhouse;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import co.adcel.ads.rtb.InterstitialAdEventListener;
import co.adcel.inhouse.InterstitialAd;
import co.adcel.inhouse.view.InHouseImageView;
import co.adcel.inhouse.view.InHouseVideoView;
import co.adcel.inhouse.view.InHouseView;

public class InHouseActivity
extends Activity
implements View.OnClickListener {
    private static InterstitialAd interstitialAd;
    private static InterstitialAdEventListener interstitialAdEventListener;
    private InHouseView view;
    private Configuration mDefaultConfig;
    private InterstitialAd mInterstitialAd;
    private InterstitialAdEventListener mInterstitialAdEventListener;

    static void start(Activity activity, InterstitialAd interstitialAd, InterstitialAdEventListener interstitialAdEventListener) {
        InHouseActivity.interstitialAd = interstitialAd;
        InHouseActivity.interstitialAdEventListener = interstitialAdEventListener;
        Intent intent = new Intent((Context)activity, InHouseActivity.class);
        intent.setFlags(65536);
        activity.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mInterstitialAd = interstitialAd;
        this.mInterstitialAdEventListener = interstitialAdEventListener;
        interstitialAd = null;
        interstitialAdEventListener = null;
        if (this.mInterstitialAd == null) {
            this.finish();
        }
        switch (this.mInterstitialAd.getAdType()) {
            case "image": {
                this.view = new InHouseImageView((Context)this, this.mInterstitialAd.getAd(), this.mInterstitialAdEventListener);
                break;
            }
            default: {
                this.view = new InHouseVideoView((Context)this, this.mInterstitialAd.getAd(), this.mInterstitialAd, this.mInterstitialAdEventListener);
            }
        }
        if (this.view != null) {
            this.setContentView((View)this.view);
            this.view.setClickListener(this);
            this.mDefaultConfig = this.getResources().getConfiguration();
            String orientation = this.view.getOrientationAd();
            if (!orientation.equals("all")) {
                if (orientation.equals("landscape")) {
                    this.setRequestedOrientation(0);
                } else if (orientation.equals("portrait")) {
                    this.setRequestedOrientation(1);
                }
            }
            this.setConfigOrientation(this.getStringOrientation(this.getResources().getConfiguration()));
        } else {
            this.failedToShow();
        }
    }

    private void failedToShow() {
        if (this.mInterstitialAdEventListener != null) {
            this.mInterstitialAdEventListener.onAdShowFailed();
        }
        this.finish();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setConfigOrientation(this.getStringOrientation(newConfig));
    }

    private String getStringOrientation(Configuration newConfig) {
        if (newConfig.orientation == 2) {
            return "image_l";
        }
        if (newConfig.orientation == 1) {
            return "image_p";
        }
        return "image_l";
    }

    private void setConfigOrientation(String orientation) {
        this.view.setOrientationShow(orientation);
        this.view.prepareForShow();
    }

    public void onBackPressed() {
        if (this.view != null) {
            this.view.closeView();
        }
        this.setRequestedOrientation(this.mDefaultConfig.orientation);
        this.finish();
    }

    public void onClick(View v) {
        switch (v.getTag().toString()) {
            case "BUTTON_NAME_CLOSE": {
                this.view.closeView();
                this.finish();
                break;
            }
            case "BUTTON_NAME_DOWNLOAD": {
                this.view.clickAd();
                this.finish();
                break;
            }
            case "BUTTON_NAME_SKIP": {
                if (!(this.view instanceof InHouseVideoView)) break;
                ((InHouseVideoView)this.view).skipVideo();
                break;
            }
            case "BUTTON_NAME_MUTE": {
                if (!(this.view instanceof InHouseVideoView)) break;
                ((InHouseVideoView)this.view).toggleMute();
            }
        }
    }
}

