/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.inhouse;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import co.adcel.ads.base.WebServiceCallback;
import co.adcel.ads.base.WebServiceError;
import co.adcel.ads.inhouse.InHouseRequest;
import co.adcel.ads.inhouse.InHouseWebService;
import co.adcel.common.TypeConverter;
import co.adcel.common.Utilities;
import co.adcel.inhouse.AdCelInHouse;
import co.adcel.logger.AdsATALog;
import co.adcel.toolkit.JSONObjectExt;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class InHouseInitializer {
    private final int TIMEOUT_SEC = 10;
    private AdCelInHouse mInHouse;
    private boolean shouldTryToInitialize;
    private ScheduledExecutorService worker;
    private ScheduledFuture future;
    @NonNull
    private final InHouseWebService inHouseWebService;

    public InHouseInitializer(AdCelInHouse aInHouse, @NonNull InHouseWebService inHouseWebService) {
        this.mInHouse = aInHouse;
        this.inHouseWebService = inHouseWebService;
    }

    public void initializeSDK(Activity activity, String sdkKey, int adTypeMask, boolean gdprConsent) {
        if (!Utilities.isNetworkConnected((Context)activity)) {
            AdsATALog.i("WARNING: Inhouse - There is no internet connection. Timeout 10 seconds");
            this.shouldTryToInitialize = true;
            this.tryInitialize(activity, sdkKey, adTypeMask, gdprConsent);
            return;
        }
        this.shouldTryToInitialize = false;
        this.getInHouseSettings(activity, sdkKey, adTypeMask, gdprConsent);
    }

    private void getInHouseSettings(final Activity activity, final String sdkKey, final int adTypeMask, final boolean gdprConsent) {
        InHouseRequest request = new InHouseRequest(TypeConverter.getTypesFromMask(adTypeMask), Utilities.getOpenDate2((Context)activity), Utilities.getInHouseClickId((Context)activity), Build.VERSION.RELEASE, Utilities.isConnectedWifi((Context)activity) ? "wifi" : "cellular", gdprConsent);
        this.inHouseWebService.getInHouseRawString(request, new WebServiceCallback<String>(){

            @Override
            public void onSuccess(@NonNull String response) {
                try {
                    JSONObject json = new JSONObject(response);
                    String status = JSONObjectExt.optString(json, "status");
                    if (status == null || !status.equals("ok")) {
                        InHouseInitializer.this.onError(activity, sdkKey, adTypeMask, gdprConsent, status);
                        return;
                    }
                    if (json.has("ads")) {
                        String type;
                        if ((json = json.getJSONObject("ads")).has(type = "image")) {
                            Utilities.saveStringLocalData((Context)activity, String.format("providerInHouseParams_%s", type), json.getJSONArray(type).toString());
                        }
                        if (json.has(type = "interstitial")) {
                            Utilities.saveStringLocalData((Context)activity, String.format("providerInHouseParams_%s", type), json.getJSONArray(type).toString());
                        }
                        if (json.has(type = "video")) {
                            Utilities.saveStringLocalData((Context)activity, String.format("providerInHouseParams_%s", type), json.getJSONArray(type).toString());
                        }
                        if (json.has(type = "reward")) {
                            Utilities.saveStringLocalData((Context)activity, String.format("providerInHouseParams_%s", type), json.getJSONArray(type).toString());
                        }
                    }
                }
                catch (Exception e) {
                    AdsATALog.i("ERROR: Inhouse - " + e.getLocalizedMessage());
                }
            }

            @Override
            public void onError(@NonNull WebServiceError error) {
                InHouseInitializer.this.onError(activity, sdkKey, adTypeMask, gdprConsent, error.getMessage());
            }
        });
    }

    private void onError(Activity activity, String sdkKey, int adTypeMask, boolean gdprConsent, String errorMessage) {
        AdsATALog.i("WARNING: Inhouse - " + errorMessage);
        if (!Utilities.isNetworkConnected((Context)activity)) {
            AdsATALog.i("WARNING: Inhouse - No connection to the service. Timeout 10 seconds. Reading params from cache.");
            this.shouldTryToInitialize = true;
            this.tryInitialize(activity, sdkKey, adTypeMask, gdprConsent);
        }
    }

    private void tryInitialize(final Activity activity, final String sdkKey, final int adTypeMask, final boolean gdprConsent) {
        if (this.worker != null || this.future != null) {
            return;
        }
        this.worker = Executors.newSingleThreadScheduledExecutor();
        this.future = this.worker.schedule(new Runnable(){

            @Override
            public void run() {
                InHouseInitializer.this.future = null;
                InHouseInitializer.this.worker = null;
                if (InHouseInitializer.this.shouldTryToInitialize) {
                    InHouseInitializer.this.initializeSDK(activity, sdkKey, adTypeMask, gdprConsent);
                }
            }
        }, 10L, TimeUnit.SECONDS);
    }
}

