/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.inhouse;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import co.adcel.ads.rtb.InterstitialAdEventListener;
import co.adcel.common.Utilities;
import co.adcel.inhouse.Ad;
import co.adcel.inhouse.AdCelInHouse;
import co.adcel.inhouse.InHouseActivity;
import co.adcel.inhouse.requests.FileLoaderTask;
import co.adcel.inhouse.requests.FileRequestCallback;
import java.io.File;
import java.lang.ref.WeakReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InterstitialAd {
    private Ad mAd;
    private InterstitialAdEventListener mListener;
    private WeakReference<Activity> mActivityRef = new WeakReference<Object>(null);
    private String mAdType;
    private boolean isReady;
    protected Boolean isImageTypeInitialized = false;
    protected Boolean isVideoTypeInitialized = false;
    protected Boolean isRewardTypeInitialized = false;
    private boolean gdprConsent = true;

    public InterstitialAd(Activity activity, String adType, InterstitialAdEventListener listener) {
        this.mActivityRef = new WeakReference<Activity>(activity);
        this.mAdType = adType;
        this.mListener = listener;
        this.parseSettingsFromJSON();
    }

    public void setGdprConsent(boolean gdprConsent) {
        this.gdprConsent = gdprConsent;
    }

    public String getAdType() {
        return this.mAdType;
    }

    Ad getAd() {
        return this.mAd;
    }

    public Boolean isImageTypeInitialized() {
        return this.isImageTypeInitialized;
    }

    public Boolean isVideoTypeInitialized() {
        return this.isVideoTypeInitialized;
    }

    public Boolean isRewardTypeInitialized() {
        return this.isRewardTypeInitialized;
    }

    public void showAd() {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity != null) {
            InHouseActivity.start(activity, this, this.mListener);
        } else {
            this.mListener.onAdShowFailed();
        }
    }

    public boolean isReadyToShow() {
        return this.isReady;
    }

    private void refreshSettings(String adType) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity != null) {
            AdCelInHouse.refreshSettings(activity, this.getMaskByAdType(adType), this.gdprConsent);
        }
    }

    private int getMaskByAdType(String adType) {
        int mask = 0;
        if (adType.contains("interstitial")) {
            mask |= 4;
        }
        if (adType.contains("image")) {
            mask |= 1;
        }
        if (adType.contains("video")) {
            mask |= 2;
        }
        if (adType.contains("reward")) {
            mask |= 8;
        }
        if (adType.contains("banner")) {
            mask |= 0x20;
        }
        return mask;
    }

    public void resume(Activity activity) {
        this.mActivityRef = new WeakReference<Activity>(activity);
    }

    private void parseSettingsFromJSON() {
        this.mAd = this.getAdByType(this.mAdType);
        if (this.mAd != null) {
            this.getStaticImageUrl(this.mAd);
            if (!this.mAdType.equals("image")) {
                this.getInterstitialVideo(this.mAd);
            }
        } else {
            this.onAdLoadFailure(String.format("Inhouse error init for %s ads type", this.mAdType));
        }
    }

    private void getStaticImageUrl(Ad ad) {
        if (!this.downloadAdSourceFile(ad)) {
            this.onAdLoadFailure(String.format("%sInHouse: Fail to load static images", this.mAdType));
        } else {
            this.isImageTypeInitialized = true;
        }
    }

    private void getInterstitialVideo(Ad ad) {
        if (ad != null && ad.getVideo() != null) {
            String videoUrl = ad.getVideo().getDownload();
            this.isVideoTypeInitialized = true;
            this.isRewardTypeInitialized = this.mAdType.equals("reward");
            if (videoUrl != null && videoUrl.length() != 0 && !this.downloadAdSourceFile(videoUrl)) {
                this.onAdLoadFailure(String.format("%sInHouse: Fail to load video", this.mAdType));
            }
        }
    }

    Ad getAdByType(String type) {
        try {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity == null) {
                return null;
            }
            JSONArray jsonArray = new JSONArray(Utilities.readStringLocalData((Context)activity, String.format("providerInHouseParams_%s", type)));
            if (jsonArray != null) {
                if (jsonArray.length() != 0) {
                    JSONObject json = jsonArray.getJSONObject(0);
                    if (json != null) {
                        return Ad.get(json);
                    }
                    this.onAdLoadFailure(String.format("No data in the collection for init %s ads type", type));
                    return null;
                }
                this.onAdLoadFailure(String.format("No fill for %s ads type", type));
                this.refreshSettings(type);
                return null;
            }
            this.onAdLoadFailure(String.format("No data for init %s ads type", type));
            return null;
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected String getTempDestinationFolder() {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity != null) {
            File f = activity.getCacheDir();
            if (!f.exists()) {
                f.mkdir();
            }
            return f.getAbsolutePath();
        }
        return null;
    }

    protected String getFileNameFromUrl(String value) {
        String[] arr = value.split("/");
        if (arr.length != 0) {
            return arr[arr.length - 1];
        }
        return "";
    }

    protected boolean downloadAdSourceFile(Ad ad) {
        if (ad != null && ad.getStatic() != null) {
            boolean isImageLoaded = this.downloadAdSourceFile(ad.getStatic().getImageLandscape());
            return isImageLoaded |= this.downloadAdSourceFile(ad.getStatic().getImagePortrait());
        }
        return false;
    }

    protected boolean downloadAdSourceFile(String url) {
        String path = this.getTempDestinationFolder();
        if (path == null) {
            return false;
        }
        String fileName = this.getFileNameFromUrl(url);
        if (fileName.length() != 0) {
            this.taskExecute(new FileLoaderTask(url, String.format("%s/%s", path, fileName), new FileRequestCallback(){

                @Override
                public void onTaskDone(File file) {
                    InterstitialAd.this.onAdLoadSuccess();
                    InterstitialAd.this.isReady = true;
                }

                @Override
                public void onTaskError(String errorResult) {
                    InterstitialAd.this.onAdLoadFailure(errorResult);
                }
            }));
            return true;
        }
        return false;
    }

    protected void taskExecute(FileLoaderTask task) {
        if (Build.VERSION.SDK_INT >= 11) {
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[0]);
        } else {
            task.execute(new String[0]);
        }
    }

    void onAdLoadSuccess() {
        if (this.mListener != null) {
            this.mListener.onAdLoadSuccess(0);
        }
    }

    void onAdLoadFailure(String error) {
        if (this.mListener != null) {
            this.mListener.onAdLoadFailure(error);
        }
    }
}

