/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.inhouse.requests;

import android.os.AsyncTask;
import co.adcel.inhouse.requests.FileRequestCallback;
import co.adcel.logger.AdsATALog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;

public class FileLoaderTask
extends AsyncTask<String, String, File> {
    private String mSourceUrl;
    private String mDestinationPath;
    private FileRequestCallback mListener;
    private int mStatusCode;

    public FileLoaderTask(String url, String path, FileRequestCallback listener) {
        this.mSourceUrl = url;
        this.mDestinationPath = path;
        this.mListener = listener;
    }

    protected void onPostExecute(File file) {
        super.onPostExecute((Object)file);
        if (file == null) {
            this.mListener.onTaskError(String.format("There is no data downloaded, http status code: %d", this.mStatusCode));
        } else {
            this.mListener.onTaskDone(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File doInBackground(String ... params) {
        InputStream input = null;
        FileOutputStream output = null;
        HttpURLConnection connection = null;
        try {
            int count;
            URL url = new URL(this.mSourceUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            if (connection.getResponseCode() != 200) {
                this.mListener.onTaskError(String.format("Server returned HTTP %s %s", connection.getResponseCode(), connection.getResponseMessage()));
                File file = null;
                return file;
            }
            input = connection.getInputStream();
            output = new FileOutputStream(this.mDestinationPath);
            byte[] data = new byte[4096];
            while ((count = input.read(data)) != -1) {
                ((OutputStream)output).write(data, 0, count);
            }
            File file = new File(this.mDestinationPath);
            return file;
        }
        catch (MalformedURLException e) {
            AdsATALog.e("FileLoaderTask error: " + e.getMessage());
        }
        catch (SocketTimeoutException e) {
            AdsATALog.e("FileLoaderTask error: " + e.getMessage());
        }
        catch (IOException e) {
            AdsATALog.e("FileLoaderTask error: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }
}

