/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.inhouse.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.VideoView;
import co.adcel.ads.rtb.InterstitialAdEventListener;
import co.adcel.inhouse.Ad;
import co.adcel.inhouse.InterstitialAd;
import co.adcel.inhouse.common.VideoTimerTask;
import co.adcel.inhouse.drawable.BackgroundButtonVideoSettings;
import co.adcel.inhouse.view.InHouseView;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class InHouseVideoView
extends InHouseView {
    private InterstitialAd mInterstitialAd;
    private VideoView mVideoView;
    private MediaPlayer.OnCompletionListener onCompletionListener;
    private MediaPlayer.OnPreparedListener onPreparedListener;
    private Button mBtnSkip;
    private Button mBtnMute;
    private TextView mVideoTimeline;
    private Boolean isVideoMute = false;
    private MediaPlayer mMediaPlayer;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private Timer mVideoTimer;
    private ScheduledExecutorService worker;
    private ScheduledFuture future;

    public InHouseVideoView(Context mContext, Ad ad, InterstitialAd interstitialAd, InterstitialAdEventListener interstitialAdEventListener) {
        super(mContext, ad, interstitialAdEventListener);
        this.mInterstitialAd = interstitialAd;
    }

    @Override
    protected void initView(InterstitialAdEventListener listener) {
        super.initView(listener);
        this.createVideoViewListeners();
        this.mBtnDownload.setVisibility(8);
        this.mBtnClose.setVisibility(8);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mVideoView = new VideoView(this.getContext());
        this.mVideoView.setOnPreparedListener(this.onPreparedListener);
        this.mVideoView.setOnCompletionListener(this.onCompletionListener);
        this.addView((View)this.mVideoView, params);
        RelativeLayout.LayoutParams paramsRL = new RelativeLayout.LayoutParams(-2, -2);
        paramsRL.addRule(10);
        paramsRL.addRule(9);
        paramsRL.setMargins(20, 20, 0, 0);
        this.mBtnSkip = new Button(this.getContext());
        this.mBtnSkip.setTag((Object)"BUTTON_NAME_SKIP");
        this.mBtnSkip.setText((CharSequence)"Skip");
        this.mBtnSkip.setBackgroundDrawable((Drawable)new BackgroundButtonVideoSettings());
        this.mBtnSkip.setTextColor(-12303292);
        this.addView((View)this.mBtnSkip, (ViewGroup.LayoutParams)paramsRL);
        if (this.mAd.getVideo() != null && this.mAd.getVideo().getSkipTimer() >= 0) {
            this.mBtnSkip.setVisibility(8);
        }
        if (this.mAd.getVideo() != null && this.mAd.getVideo().getSkipTimer() > 0 && this.worker == null && this.future == null) {
            this.worker = Executors.newSingleThreadScheduledExecutor();
            this.future = this.worker.schedule(new Runnable(){

                @Override
                public void run() {
                    InHouseVideoView.this.future = null;
                    InHouseVideoView.this.worker = null;
                    InHouseVideoView.this.mBtnSkip.post(new Runnable(){

                        @Override
                        public void run() {
                            InHouseVideoView.this.mBtnSkip.setVisibility(0);
                        }
                    });
                }
            }, (long)this.mAd.getVideo().getSkipTimer(), TimeUnit.SECONDS);
        }
        paramsRL = new RelativeLayout.LayoutParams(-2, -2);
        paramsRL.addRule(11);
        paramsRL.addRule(10);
        paramsRL.setMargins(0, 20, 20, 0);
        this.mBtnMute = new Button(this.getContext());
        this.mBtnMute.setTag((Object)"BUTTON_NAME_MUTE");
        this.mBtnMute.setText((CharSequence)"Mute");
        this.mBtnMute.setBackgroundDrawable((Drawable)new BackgroundButtonVideoSettings());
        this.mBtnMute.setTextColor(-12303292);
        this.addView((View)this.mBtnMute, (ViewGroup.LayoutParams)paramsRL);
        this.mVideoTimeline = new TextView(this.getContext());
        this.mVideoTimeline.setText((CharSequence)"%s seconds remaining...");
        paramsRL = new RelativeLayout.LayoutParams(-2, -2);
        paramsRL.addRule(9);
        paramsRL.addRule(12);
        paramsRL.setMargins(20, 0, 0, 20);
        this.addView((View)this.mVideoTimeline, (ViewGroup.LayoutParams)paramsRL);
    }

    private void createVideoViewListeners() {
        this.onCompletionListener = new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                if (InHouseVideoView.this.mVideoTimer != null) {
                    InHouseVideoView.this.mVideoTimer.cancel();
                    InHouseVideoView.this.mVideoTimer = null;
                }
                if (InHouseVideoView.this.mInterstitialAd.isImageTypeInitialized().booleanValue() && InHouseVideoView.this.mImageAdView != null && InHouseVideoView.this.mVideoView != null) {
                    InHouseVideoView.this.hideVideo();
                    InHouseVideoView.this.showImage();
                }
                if (InHouseVideoView.this.mInterstitialAd.isRewardTypeInitialized().booleanValue()) {
                    InHouseVideoView.this.onAdRewardComplete();
                }
            }
        };
        this.onPreparedListener = new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                InHouseVideoView.this.mMediaPlayer = mp;
            }
        };
    }

    @Override
    public void prepareForShow() {
        File file;
        if (this.mInterstitialAd.isImageTypeInitialized().booleanValue()) {
            file = new File(String.format("%s/%s", this.getTempDestinationFolder(), this.getFileNameFromUrl((String)this.mImageURLMap.get(this.mOrientationShow))));
            if (file.exists()) {
                Bitmap myBitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
                this.mImageAdView.setImageBitmap(myBitmap);
                if (!this.mInterstitialAd.isVideoTypeInitialized().booleanValue()) {
                    this.onAdShow();
                }
            } else if (!this.mInterstitialAd.isVideoTypeInitialized().booleanValue()) {
                this.onAdShowFailed();
            }
        }
        if (this.mInterstitialAd.isVideoTypeInitialized().booleanValue()) {
            if (this.mAd != null && this.mAd.getVideo() != null) {
                file = new File(String.format("%s/%s", this.getTempDestinationFolder(), this.getFileNameFromUrl(this.mAd.getVideo().getDownload())));
                if (file.exists()) {
                    this.mVideoView.setVideoURI(Uri.parse((String)file.getAbsolutePath()));
                    this.startVideoAd(700);
                } else {
                    this.onAdShowFailed();
                }
            } else {
                this.onAdShowFailed();
            }
        }
    }

    private void startVideoAd(int waiting) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (InHouseVideoView.this.mVideoView != null) {
                    InHouseVideoView.this.onAdShow();
                    InHouseVideoView.this.mVideoView.start();
                    InHouseVideoView.this.mVideoTimer = new Timer();
                    InHouseVideoView.this.mVideoTimer.scheduleAtFixedRate((TimerTask)new VideoTimerTask((Activity)InHouseVideoView.this.getContext(), InHouseVideoView.this), 500L, 500L);
                } else {
                    InHouseVideoView.this.onAdShowFailed();
                }
            }
        };
        this.startRunnable(runnable, waiting);
    }

    private void startRunnable(Runnable runnable, int waiting) {
        if (waiting != 0) {
            this.mHandler.postDelayed(runnable, (long)waiting);
        } else {
            this.mHandler.post(runnable);
        }
    }

    public void updateTimeLine() {
        if (this.mVideoView != null) {
            long time = Math.round(Math.ceil((this.mVideoView.getDuration() - this.mVideoView.getCurrentPosition()) / 1000));
            this.mVideoTimeline.setText((CharSequence)String.format("%s seconds remaining...", time));
        }
    }

    @Override
    public void clickAd() {
        super.clickAd();
        this.onAdClick();
    }

    @Override
    public void setClickListener(View.OnClickListener listener) {
        this.mBtnDownload.setOnClickListener(listener);
        this.mBtnClose.setOnClickListener(listener);
        this.mBtnMute.setOnClickListener(listener);
        this.mBtnSkip.setOnClickListener(listener);
    }

    @Override
    public void closeView() {
        this.onAdClose();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.destroyVideoView();
    }

    private void destroyVideoView() {
        if (this.mVideoView != null) {
            this.mVideoView.suspend();
            this.mVideoView.stopPlayback();
            this.mVideoView.setVisibility(8);
            this.removeView((View)this.mVideoView);
            this.mVideoView = null;
        }
    }

    public void skipVideo() {
        this.hideVideo();
        this.showImage();
    }

    private void showImage() {
        this.mBtnDownload.setVisibility(0);
        this.mBtnClose.setVisibility(0);
    }

    private void hideVideo() {
        this.destroyVideoView();
        this.mVideoTimeline.setVisibility(8);
        this.mBtnSkip.setVisibility(8);
        this.mBtnMute.setVisibility(8);
    }

    public void toggleMute() {
        this.isVideoMute = this.isVideoMute == false;
        if (this.mMediaPlayer != null) {
            if (this.isVideoMute.booleanValue()) {
                this.mMediaPlayer.setVolume(0.0f, 0.0f);
            } else {
                this.mMediaPlayer.setVolume(1.0f, 1.0f);
            }
        }
    }
}

