/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.inhouse.view;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import co.adcel.ads.rtb.InterstitialAdEventListener;
import co.adcel.common.Utilities;
import co.adcel.inhouse.Ad;
import co.adcel.inhouse.drawable.BackgroundButtonClose;
import co.adcel.inhouse.drawable.BackgroundButtonDownload;
import java.io.File;
import java.util.HashMap;

public abstract class InHouseView
extends RelativeLayout {
    protected Ad mAd;
    private InterstitialAdEventListener mInterstitialAdEventListener;
    protected String mOrientationShow = "";
    protected HashMap<String, String> mImageURLMap = new HashMap();
    protected ImageView mImageAdView;
    protected Button mBtnDownload;
    protected Button mBtnClose;

    public InHouseView(Context context, Ad ad, InterstitialAdEventListener interstitialAdEventListener) {
        super(context);
        this.mAd = ad;
        this.mInterstitialAdEventListener = interstitialAdEventListener;
        if (this.mAd != null && ad.getStatic() != null) {
            this.mImageURLMap.put("image_l", ad.getStatic().getImageLandscape());
            this.mImageURLMap.put("image_p", ad.getStatic().getImagePortrait());
        }
        this.prepareRootView();
        this.initView(this.mInterstitialAdEventListener);
    }

    public InHouseView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public InHouseView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void initView(final InterstitialAdEventListener listener) {
        this.mImageAdView = new ImageView(this.getContext());
        this.mImageAdView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InHouseView.this.clickAd();
                listener.onAdClick();
            }
        });
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.addView((View)this.mImageAdView, params);
        RelativeLayout.LayoutParams paramsRL = new RelativeLayout.LayoutParams(-2, -2);
        paramsRL.addRule(12);
        paramsRL.addRule(14);
        paramsRL.setMargins(0, 0, 0, 50);
        this.mBtnDownload = new Button(this.getContext());
        this.mBtnDownload.setTag((Object)"BUTTON_NAME_DOWNLOAD");
        if (this.mAd.getStatic() != null) {
            this.mBtnDownload.setText((CharSequence)this.mAd.getStatic().getCta());
        }
        this.mBtnDownload.setBackgroundDrawable((Drawable)new BackgroundButtonDownload());
        this.mBtnDownload.setTextColor(-1);
        this.addView((View)this.mBtnDownload, (ViewGroup.LayoutParams)paramsRL);
        paramsRL = new RelativeLayout.LayoutParams(80, 80);
        paramsRL.addRule(11);
        paramsRL.addRule(10);
        paramsRL.setMargins(0, 20, 20, 0);
        this.mBtnClose = new Button(this.getContext());
        this.mBtnClose.setTag((Object)"BUTTON_NAME_CLOSE");
        this.mBtnClose.setText((CharSequence)"X");
        this.mBtnClose.setBackgroundDrawable((Drawable)new BackgroundButtonClose());
        this.mBtnClose.setTextColor(-16777216);
        this.mBtnClose.setPadding(6, 6, 6, 6);
        this.addView((View)this.mBtnClose, (ViewGroup.LayoutParams)paramsRL);
    }

    protected void prepareRootView() {
        this.setBackgroundColor(-16777216);
    }

    protected String getTempDestinationFolder() {
        File f = this.getContext().getCacheDir();
        if (!f.exists()) {
            f.mkdir();
        }
        return f.getAbsolutePath();
    }

    protected String getFileNameFromUrl(String value) {
        String[] arr = value.split("/");
        if (arr.length != 0) {
            return arr[arr.length - 1];
        }
        return "";
    }

    public void clickAd() {
        String storeId = this.mAd.getStoreId();
        String clickId = this.mAd.getClickId();
        if (storeId != null && storeId.length() != 0 && clickId != null && clickId.length() != 0) {
            Utilities.saveInHouseClickId(this.getContext(), storeId, clickId);
        }
        Intent i = new Intent("android.intent.action.VIEW");
        i.setData(Uri.parse((String)this.mAd.getClickUrl()));
        this.getContext().startActivity(i);
    }

    public String getOrientationAd() {
        if (this.mAd != null && this.mAd.getVideo() != null && this.mAd.getStatic() != null) {
            return this.mAd.getVideo().getOrientation().length() != 0 ? this.mAd.getVideo().getOrientation() : this.mAd.getStatic().getOrientation();
        }
        return "all";
    }

    public void setOrientationShow(String mOrientationShow) {
        this.mOrientationShow = mOrientationShow;
    }

    void onAdShow() {
        if (this.mInterstitialAdEventListener != null) {
            this.mAd.registerImpression();
            this.mInterstitialAdEventListener.onAdShow();
        }
    }

    void onAdShowFailed() {
        if (this.mInterstitialAdEventListener != null) {
            this.mInterstitialAdEventListener.onAdShowFailed();
        }
    }

    void onAdClick() {
        if (this.mInterstitialAdEventListener != null) {
            this.mAd.registerClick();
            this.mInterstitialAdEventListener.onAdClick();
        }
    }

    void onAdClose() {
        if (this.mInterstitialAdEventListener != null) {
            this.mInterstitialAdEventListener.onAdClose();
        }
    }

    void onAdRewardComplete() {
        if (this.mInterstitialAdEventListener != null) {
            this.mInterstitialAdEventListener.onAdRewardComplete();
        }
    }

    public abstract void closeView();

    public abstract void prepareForShow();

    public abstract void setClickListener(View.OnClickListener var1);
}

