/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.init;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.Nullable;
import co.adcel.adbanner.AdCelBanner;
import co.adcel.ads.base.SdkPlugin;
import co.adcel.ads.mediation.CredentialsService;
import co.adcel.ads.mediation.DefaultDependenciesFactory;
import co.adcel.ads.mediation.DependenciesFactory;
import co.adcel.ads.mediation.Mediation;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.ads.mediation.SessionLoggerService;
import co.adcel.ads.mediation.StatService;
import co.adcel.ads.rtb.AudioAd;
import co.adcel.common.AdCelPluginName;
import co.adcel.common.ProviderUpdateAction;
import co.adcel.common.TypeConverter;
import co.adcel.common.Utilities;
import co.adcel.init.AdCelInitializationListener;
import co.adcel.init.AdType;
import co.adcel.interstitialads.InterstitialAdTest;
import co.adcel.interstitialads.InterstitialAdsManager;
import co.adcel.interstitialads.InterstitialListener;
import co.adcel.interstitialads.rewarded.RewardedAdValues;
import co.adcel.logger.AdsATALog;
import co.adcel.logger.LogEventListener;
import co.adcel.nativeads.AdCelNative;
import co.adcel.nativeads.OnNativeAdsAvailabilityListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public final class AdCel
implements AdType {
    public static final String VERSION = "1.12.4";
    public static final int MASK_IMAGE = 1;
    public static final int MASK_VIDEO = 2;
    public static final int MASK_INTERSTITIAL = 4;
    public static final int MASK_REWARDED = 8;
    public static final int MASK_NATIVE = 16;
    public static final int MASK_BANNER = 32;
    public static final int MASK_AUDIO = 64;
    private static AdCel adcelInstance;
    private static Boolean isTestModeEnabled;
    private final MediationContext mediationContext = new MediationContext(this);
    private DependenciesFactory dependenciesFactory;
    private Mediation mediation;
    @Nullable
    private AdCelPluginName adCelPluginName;
    private boolean resumed = false;

    public static MediationContext getMediationContextForBanner(AdCelBanner adcelBanner) {
        if (adcelBanner == null) {
            throw new IllegalArgumentException("adcelBanner can't be null");
        }
        MediationContext mediationContext = AdCel.getInstance().getMediationContext();
        return mediationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AdCel getInstance() {
        AdCel localInstance = adcelInstance;
        if (localInstance != null) return localInstance;
        Class<AdCel> clazz = AdCel.class;
        synchronized (AdCel.class) {
            localInstance = adcelInstance;
            if (localInstance != null) return localInstance;
            adcelInstance = localInstance = new AdCel();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localInstance;
        }
    }

    private AdCel() {
    }

    private void setAdCelPluginName(AdCelPluginName adCelPluginName) {
        this.adCelPluginName = adCelPluginName;
    }

    public MediationContext getMediationContext() {
        return this.mediationContext;
    }

    public static void initializeSDK(Activity activity, String sdkKey, int adTypeMask) {
        AdCel.initializeSDK(activity, sdkKey, adTypeMask, true);
    }

    public static void initializeSDK(Activity activity, String sdkKey, String ... types) {
        int adTypeMask = TypeConverter.getMaskFromTypes(types);
        AdCel.initializeSDK(activity, sdkKey, adTypeMask);
    }

    public static void initializeSDK(Activity activity, String sdkKey, int adTypeMask, AdCelInitializationListener initializationListener) {
        AdCel.initializeSDK(activity, sdkKey, adTypeMask, true, initializationListener);
    }

    public static void initializeSDK(Activity activity, String sdkKey, int adTypeMask, boolean startCachingImmediately) {
        AdCel.initializeSDK(activity, sdkKey, adTypeMask, startCachingImmediately, null);
    }

    public static void initializeSDK(Activity activity, String sdkKey, int adTypeMask, boolean startCachingImmediately, AdCelInitializationListener initializationListener) {
        AdCel.getInstance().initialize(activity, sdkKey, adTypeMask, startCachingImmediately, initializationListener);
    }

    private void initialize(final Activity activity, final String sdkKey, final int adTypeMask, final boolean startCachingImmediately, final AdCelInitializationListener initializationListener) {
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AdCel.this.getMediationContext().setSdkKey(sdkKey);
                AdCel.this.getMediationContext().setContext(activity);
                Context context = activity.getApplicationContext();
                SdkPlugin sdkPlugin = null;
                if (AdCel.this.adCelPluginName != null) {
                    sdkPlugin = SdkPlugin.fromName(AdCel.this.adCelPluginName.getValue());
                }
                AdCel.this.dependenciesFactory = new DefaultDependenciesFactory(context, sdkKey, sdkPlugin);
                CredentialsService credentialsService = AdCel.this.dependenciesFactory.getCredentialsService();
                StatService statService = AdCel.this.dependenciesFactory.getStatService();
                SessionLoggerService sessionLoggerService = new SessionLoggerService(AdCel.this.dependenciesFactory.getLogService());
                AdCel.this.mediation = new Mediation(AdCel.this, credentialsService, statService, sessionLoggerService);
                AdCel.this.mediation.setInitializationListener(initializationListener);
                AdCel.this.mediation.init(activity, adTypeMask, startCachingImmediately);
                if (!AdCel.getInstance().resumed) {
                    AdCel.onResume(activity);
                } else {
                    AdCel.this.mediation.resumeSession();
                }
            }
        });
    }

    public static void startCaching() {
        if (!AdCel.isSDKInitialized()) {
            return;
        }
        final MediationContext mediationContext = AdCel.getInstance().getMediationContext();
        Activity activity = mediationContext.getActivity();
        if (activity == null) {
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                InterstitialAdsManager interstitialAdsManager = mediationContext.getInterstitialAdsManager();
                if (interstitialAdsManager.isInitialized() && !interstitialAdsManager.isInitializationStarted()) {
                    interstitialAdsManager.initializeAllProviders();
                }
                if ((interstitialAdsManager = mediationContext.getImageAdsManager()).isInitialized() && !interstitialAdsManager.isInitializationStarted()) {
                    interstitialAdsManager.initializeAllProviders();
                }
                if ((interstitialAdsManager = mediationContext.getVideoAdsManager()).isInitialized() && !interstitialAdsManager.isInitializationStarted()) {
                    interstitialAdsManager.initializeAllProviders();
                }
                if ((interstitialAdsManager = mediationContext.getRewardedAdsManager()).isInitialized() && !interstitialAdsManager.isInitializationStarted()) {
                    interstitialAdsManager.initializeAllProviders();
                }
            }
        });
    }

    public static void stopCaching() {
        if (!AdCel.isSDKInitialized()) {
            return;
        }
        final MediationContext mediationContext = AdCel.getInstance().getMediationContext();
        Activity activity = mediationContext.getActivity();
        if (activity == null) {
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                InterstitialAdsManager interstitialAdsManager = mediationContext.getInterstitialAdsManager();
                if (interstitialAdsManager.isInitialized()) {
                    interstitialAdsManager.stop();
                }
                if ((interstitialAdsManager = mediationContext.getImageAdsManager()).isInitialized()) {
                    interstitialAdsManager.stop();
                }
                if ((interstitialAdsManager = mediationContext.getVideoAdsManager()).isInitialized()) {
                    interstitialAdsManager.stop();
                }
                if ((interstitialAdsManager = mediationContext.getRewardedAdsManager()).isInitialized()) {
                    interstitialAdsManager.stop();
                }
            }
        });
    }

    public static boolean isCachingStarted() {
        if (!AdCel.isSDKInitialized()) {
            return false;
        }
        boolean isCachingStarted = true;
        MediationContext mediationContext = AdCel.getInstance().getMediationContext();
        InterstitialAdsManager interstitialAdsManager = mediationContext.getInterstitialAdsManager();
        if (interstitialAdsManager.isInitialized()) {
            isCachingStarted &= interstitialAdsManager.isInitializationStarted();
        }
        if ((interstitialAdsManager = mediationContext.getImageAdsManager()).isInitialized()) {
            isCachingStarted &= interstitialAdsManager.isInitializationStarted();
        }
        if ((interstitialAdsManager = mediationContext.getVideoAdsManager()).isInitialized()) {
            isCachingStarted &= interstitialAdsManager.isInitializationStarted();
        }
        if ((interstitialAdsManager = mediationContext.getRewardedAdsManager()).isInitialized()) {
            isCachingStarted &= interstitialAdsManager.isInitializationStarted();
        }
        return isCachingStarted;
    }

    public static void setTargetingParam(String name, String value) {
        AdCel.getInstance().getMediationContext().setTargetingParam(name, value);
    }

    public static void setLogging(boolean logging) {
        AdsATALog.logEnabled = logging;
    }

    public static void setLogEventListener(LogEventListener logEventListener) {
        AdsATALog.setLogEventListener(logEventListener);
    }

    public static boolean isSDKInitialized() {
        return adcelInstance != null;
    }

    public static boolean isLoggingEnabled() {
        return AdsATALog.logEnabled;
    }

    public static void disableAdNetwork(int adTypeMask, String ... networks) {
        for (String network : networks) {
            if ((adTypeMask & 1) == 1) {
                AdCel.getInstance().getMediationContext().disableProvider("image", network);
            }
            if ((adTypeMask & 2) == 2) {
                AdCel.getInstance().getMediationContext().disableProvider("video", network);
            }
            if ((adTypeMask & 4) == 4) {
                AdCel.getInstance().getMediationContext().disableProvider("interstitial", network);
            }
            if ((adTypeMask & 8) == 8) {
                AdCel.getInstance().getMediationContext().disableProvider("reward", network);
            }
            if ((adTypeMask & 0x10) == 16) {
                AdCel.getInstance().getMediationContext().disableProvider("native", network);
            }
            if ((adTypeMask & 0x20) != 32) continue;
            AdCel.getInstance().getMediationContext().disableProvider("banner", network);
        }
    }

    public static void showInterstitialAd(String adType) {
        AdCel.showInterstitialAd(adType, null);
    }

    public static void showInterstitialAd(final String adType, final String zone) {
        Context context = AdCel.getInstance().getMediationContext().getContext();
        if (context != null && Utilities.isNetworkConnected(context)) {
            final MediationContext mediationContext = AdCel.getInstance().getMediationContext();
            final Activity activity = mediationContext.getActivity();
            if (activity == null) {
                return;
            }
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (AdCel.isTestModeEnabled()) {
                        AdCel.displayTestAd(activity, adType);
                        return;
                    }
                    if (adType.equals("reward")) {
                        mediationContext.getRewardedAdsManager().showInterstitial(adType, zone);
                    } else if (adType.equals("image") && mediationContext.getImageAdsManager().isInitialized()) {
                        mediationContext.getImageAdsManager().showInterstitial(adType, zone);
                    } else if (adType.equals("video") && mediationContext.getVideoAdsManager().isInitialized()) {
                        mediationContext.getVideoAdsManager().showInterstitial(adType, zone);
                    } else {
                        mediationContext.getInterstitialAdsManager().showInterstitial(adType, zone);
                    }
                }
            });
        }
    }

    public static void showInterstitialAd() {
        AdCel.showInterstitialAdForZone(null);
    }

    public static void showInterstitialAdForZone(final String zone) {
        Utilities.checkActivityLifeCycleSync();
        Context context = AdCel.getInstance().getMediationContext().getContext();
        if (context != null && Utilities.isNetworkConnected(context)) {
            final MediationContext mediationContext = AdCel.getInstance().getMediationContext();
            final Activity activity = mediationContext.getActivity();
            if (activity == null) {
                return;
            }
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (AdCel.isTestModeEnabled()) {
                        AdCel.displayTestAd(activity, "image");
                        return;
                    }
                    if (mediationContext.getInterstitialAdsManager().isInitialized()) {
                        mediationContext.getInterstitialAdsManager().showInterstitial(zone);
                    } else {
                        boolean bothInitialized;
                        InterstitialAdsManager imageAdsManager = mediationContext.getImageAdsManager();
                        InterstitialAdsManager videoAdsManager = mediationContext.getVideoAdsManager();
                        int imageWeight = imageAdsManager.getHighestAvailableWeight();
                        int videoWeight = videoAdsManager.getHighestAvailableWeight();
                        boolean imageInitialized = imageAdsManager.isInitialized();
                        boolean videoInitialized = videoAdsManager.isInitialized();
                        boolean bl = bothInitialized = imageInitialized && videoInitialized;
                        if (bothInitialized && imageWeight > videoWeight || imageInitialized) {
                            imageAdsManager.showInterstitial("image", zone);
                        } else if (videoInitialized) {
                            videoAdsManager.showInterstitial("video", zone);
                        } else {
                            mediationContext.getInterstitialAdsManager().showInterstitial(zone);
                        }
                    }
                }
            });
        }
    }

    public static void loadNativeAd(Activity activity, AdCelNative.AdLoadListener adLoadListener) {
        AdCel.loadNativeAd((Context)activity, adLoadListener);
    }

    public static void loadNativeAd(Context context, AdCelNative.AdLoadListener adLoadListener) {
        AdCel.getInstance().getMediationContext().getNativeAdsManager().loadAd(context, 1, false, true, adLoadListener);
    }

    public static void loadNativeAd(Context context, int count, boolean random, boolean async, AdCelNative.AdLoadListener adLoadListener) {
        AdCel.getInstance().getMediationContext().getNativeAdsManager().loadAd(context, count, random, async, adLoadListener);
    }

    public static boolean isAvailableAd(String adType) {
        return AdCel.isAvailableAd(adType, null);
    }

    public static boolean isAvailableAd(final String adType, final String zone) {
        final MediationContext mediationContext = AdCel.getInstance().getMediationContext();
        FutureTask<Boolean> futureResult = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (adType.equals("reward")) {
                    return mediationContext.getRewardedAdsManager().isAvailable(adType, zone);
                }
                if ((adType.equals("video") || adType.equals("interstitial") && !mediationContext.getInterstitialAdsManager().isInitialized()) && mediationContext.getVideoAdsManager().isInitialized()) {
                    return mediationContext.getVideoAdsManager().isAvailable(adType, zone);
                }
                if ((adType.equals("image") || adType.equals("interstitial") && !mediationContext.getInterstitialAdsManager().isInitialized()) && mediationContext.getImageAdsManager().isInitialized()) {
                    return mediationContext.getImageAdsManager().isAvailable(adType, zone);
                }
                if (adType.equals("interstitial") || adType.equals("video") || adType.equals("image")) {
                    return mediationContext.getInterstitialAdsManager().isAvailable(adType, zone);
                }
                if (adType.equals("banner")) {
                    return AdCelBanner.isBannerAvailable();
                }
                if (adType.equals("native")) {
                    return mediationContext.getNativeAdsManager().isInitialized();
                }
                return false;
            }
        });
        Activity activity = mediationContext.getActivity();
        if (activity == null) {
            return false;
        }
        activity.runOnUiThread(futureResult);
        boolean returnValue = false;
        try {
            returnValue = futureResult.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return returnValue;
    }

    public static void setInterstitialListener(InterstitialListener interstitialListener) {
        AdCel.getInstance().getMediationContext().setInterstitialListener(interstitialListener);
    }

    @Deprecated
    public static void setNativeAdsAvailabilityListener(OnNativeAdsAvailabilityListener onNativeAdsAvailabilityListener) {
        AdCel.getInstance().getMediationContext().setOnNativeAdsAvailabilityListener(onNativeAdsAvailabilityListener);
    }

    public static void setTestMode(Boolean testMode) {
        isTestModeEnabled = testMode;
    }

    public static boolean isTestModeEnabled() {
        return isTestModeEnabled;
    }

    private static void displayTestAd(Activity activity, String adType) {
        boolean isWaterFallInitialized = AdCel.getInstance().getMediationContext().isWaterFallInitialized();
        boolean isModerated = AdCel.getInstance().getMediationContext().isModerated();
        if (adType.equals("image")) {
            InterstitialAdTest.displayTestImage(activity, isWaterFallInitialized, isModerated);
        }
        if (adType.equals("video")) {
            InterstitialAdTest.displayTestVideo(activity, isWaterFallInitialized, isModerated);
        }
        if (adType.equals("reward")) {
            InterstitialAdTest.displayTestRewarded(activity, isWaterFallInitialized, isModerated);
        }
    }

    private void pause(Activity activity) {
        this.updateProvidersSDK(ProviderUpdateAction.PAUSE, activity);
        if (this.mediation != null) {
            this.mediation.pauseSession();
        }
        this.resumed = false;
    }

    public static void onPause(Activity activity) {
        AdCel.getInstance().pause(activity);
    }

    private void resume(Activity activity) {
        this.getMediationContext().setContext(activity);
        if (this.mediation != null) {
            this.mediation.resumeSession();
        }
        if (this.resumed) {
            return;
        }
        this.resumed = true;
        Utilities.onResume();
        this.updateProvidersSDK(ProviderUpdateAction.RESUME, activity);
    }

    public static void onResume(Activity activity) {
        AdCel.getInstance().resume(activity);
    }

    private void destroy(Activity activity) {
        this.updateProvidersSDK(ProviderUpdateAction.DESTROY, activity);
        if (this.mediation != null) {
            this.mediation.pauseSession();
        }
        this.resumed = false;
    }

    public static void onDestroy(Activity activity) {
        AdCel.getInstance().destroy(activity);
    }

    public static void destroy() {
        if (!AdCel.isSDKInitialized()) {
            return;
        }
        AdCel.stopCaching();
        adcelInstance = null;
    }

    public static RewardedAdValues getRewardedAdValues() {
        return AdCel.getInstance().getMediationContext().getCurrencySettings();
    }

    public static void setUserConsent(boolean userConsent) {
        AdCel.getInstance().getMediationContext().setUserConsent(userConsent);
    }

    public static void hideInterstitial() {
        if (AdCel.getInstance().getMediationContext().getInterstitialAdsManager().isShowing()) {
            AdCel.getInstance().getMediationContext().getInterstitialAdsManager().dismiss();
        }
        if (AdCel.getInstance().getMediationContext().getImageAdsManager().isShowing()) {
            AdCel.getInstance().getMediationContext().getImageAdsManager().dismiss();
        }
        if (AdCel.getInstance().getMediationContext().getVideoAdsManager().isShowing()) {
            AdCel.getInstance().getMediationContext().getVideoAdsManager().dismiss();
        }
        if (AdCel.getInstance().getMediationContext().getRewardedAdsManager().isShowing()) {
            AdCel.getInstance().getMediationContext().getRewardedAdsManager().dismiss();
        }
    }

    public static AudioAd createAudioAd() {
        if (!AdCel.isSDKInitialized()) {
            throw new IllegalStateException("SDK not initialized");
        }
        return new AudioAd(AdCel.getInstance().getMediationContext(), null);
    }

    private void updateProvidersSDK(ProviderUpdateAction action, Activity activity) {
        AdsATALog.i("AdCelSDK: Activity.updateProvidersSDK(" + (Object)((Object)action) + ")");
        if (this.getMediationContext().getInterstitialAdsManager().isInitialized()) {
            this.getMediationContext().getInterstitialAdsManager().updateProvidersSDK(action, activity);
        }
        if (this.getMediationContext().getImageAdsManager().isInitialized()) {
            this.getMediationContext().getImageAdsManager().updateProvidersSDK(action, activity);
        }
        if (this.getMediationContext().getVideoAdsManager().isInitialized()) {
            this.getMediationContext().getVideoAdsManager().updateProvidersSDK(action, activity);
        }
        if (this.getMediationContext().getRewardedAdsManager().isInitialized()) {
            this.getMediationContext().getRewardedAdsManager().updateProvidersSDK(action, activity);
        }
    }

    public static void registerPluginName(AdCelPluginName pluginName) {
        AdCel.getInstance().setAdCelPluginName(pluginName);
    }

    @Nullable
    public static String pluginName() {
        AdCelPluginName adCelPluginName = AdCel.getInstance().adCelPluginName;
        if (adCelPluginName != null) {
            return adCelPluginName.getValue();
        }
        return null;
    }

    static {
        isTestModeEnabled = false;
    }
}

