/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.interstitialads;

import co.adcel.ads.mediation.MediationContext;
import co.adcel.common.AdProviderDTO;
import co.adcel.interstitialads.InterstitialAdProviderPopulateAdapter;
import co.adcel.interstitialads.InterstitialAdsManager;
import co.adcel.interstitialads.InterstitialProvider;
import co.adcel.logger.AdsATALog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterstitialAdProviderPopulateBase
implements InterstitialAdProviderPopulateAdapter {
    private MediationContext aContext;
    private Map<String, String> providerMap;
    private String adType;

    public InterstitialAdProviderPopulateBase(MediationContext aContext, String adType) {
        this.aContext = aContext;
        this.adType = adType;
        this.providerMap = new HashMap<String, String>();
        this.populateClasses(this.providerMap);
    }

    protected void populateClasses(Map<String, String> providerMap) {
        providerMap.put("Google Admob", "co.adcel.interstitialads.ProviderAdMob");
        providerMap.put("AdColony", "co.adcel.interstitialads.ProviderAdColony");
        providerMap.put("Applovin", "co.adcel.interstitialads.ProviderAppLovin");
        providerMap.put("MyTarget", "co.adcel.interstitialads.ProviderMyTarget");
        providerMap.put("StartApp", "co.adcel.interstitialads.ProviderStartApp");
        providerMap.put("UnityAds", "co.adcel.interstitialads.ProviderUnityAds");
        providerMap.put("Smaato", "co.adcel.interstitialads.ProviderSmaato");
        providerMap.put("Yandex", "co.adcel.interstitialads.ProviderYandex");
        providerMap.put("Amazon Mobile Ads", "co.adcel.interstitialads.ProviderAmazon");
        providerMap.put("Vungle", "co.adcel.interstitialads.ProviderVungle");
        providerMap.put("Supersonic", "co.adcel.interstitialads.ProviderSupersonic");
        providerMap.put("Facebook", "co.adcel.interstitialads.ProviderFacebook");
        providerMap.put("InHouse", "co.adcel.interstitialads.ProviderInHouse");
        providerMap.put("MoPub", "co.adcel.interstitialads.ProviderMoPub");
        providerMap.put("RTB", "co.adcel.interstitialads.ProviderAdCel");
        providerMap.put("Tapjoy", "co.adcel.interstitialads.ProviderTapjoy");
        providerMap.put("Ogury", "co.adcel.interstitialads.ProviderOgury");
        providerMap.put("InMobi", "co.adcel.interstitialads.ProviderInMobi");
        providerMap.put("Criteo", "co.adcel.interstitialads.ProviderCriteo");
        providerMap.put("Tiktok", "co.adcel.interstitialads.ProviderTiktok");
    }

    @Override
    public void populate(List<InterstitialProvider> adProvidersList, InterstitialAdsManager interstitialAdsManager) {
        List<String> queue = this.aContext.getProvidersQueues().get(this.adType);
        for (String provider : queue) {
            String providerName = provider;
            String className = this.providerMap.get(providerName);
            if (className == null || this.aContext.isProviderDisabled(this.adType, providerName)) continue;
            try {
                Class<?> clazz = Class.forName(className);
                Method m = clazz.getDeclaredMethod("isProviderInstalled", new Class[0]);
                m.setAccessible(true);
                boolean installed = (Boolean)m.invoke(null, new Object[0]);
                if (installed) {
                    AdsATALog.i(String.format("==== %s Provider %s is installed", this.adType, provider));
                    Map<String, AdProviderDTO> providerMap = this.aContext.getProvider(provider);
                    if (providerMap.get(this.adType) == null) continue;
                    InterstitialProvider interstitialProvider = (InterstitialProvider)clazz.getDeclaredConstructor(String.class, Map.class, InterstitialAdsManager.class).newInstance(this.adType, providerMap, interstitialAdsManager);
                    adProvidersList.add(interstitialProvider);
                    continue;
                }
                AdsATALog.i(String.format("==== %s Provider %s is not installed", this.adType, provider));
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                AdsATALog.i(String.format("==== %s Provider %s is not installed", this.adType, provider));
            }
            catch (Throwable e) {
                AdsATALog.e(String.format("==== %s Provider %s instantiate error: %s", this.adType, provider, e.getMessage()));
            }
        }
    }
}

