/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.interstitialads;

import android.app.Activity;
import co.adcel.ads.mediation.DefaultDependenciesFactory;
import co.adcel.ads.mediation.LogService;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.ads.mediation.SdkLog;
import co.adcel.common.CacheSettings;
import co.adcel.common.ProviderUpdateAction;
import co.adcel.interstitialads.InterstitialAdProviderPopulateAdapter;
import co.adcel.interstitialads.InterstitialProvider;
import co.adcel.interstitialads.rewarded.RewardedAdValues;
import co.adcel.logger.AdsATALog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class InterstitialAdsManager {
    private static final int REINIT_INTERVAL_SEC = 10;
    private static final int ACTIVE_PROVIDER_LIMIT = 2;
    private MediationContext mediationContext;
    private List<InterstitialProvider> adProvidersList = new ArrayList<InterstitialProvider>();
    private int adProviderIndex = 0;
    private InterstitialProvider reservedProvider = null;
    private boolean initializationStarted = false;
    private boolean firstAdLoad = true;
    private boolean isShowing;
    private boolean isWithLimit;
    private boolean allInitialized = false;
    private boolean isInitializedWaiting = false;
    private int loadedProviderCount = 0;
    private int rtbProviderCount = 0;
    private boolean tryShowWhenNotInitialized = false;
    private String zoneToShow = null;
    private String mAdType = "interstitial";
    private ScheduledExecutorService checkInitializationWorker = null;
    private ScheduledFuture checkInitializationFuture = null;
    private String sessionId = "";

    protected String getAdType() {
        return this.mAdType;
    }

    public InterstitialAdsManager(MediationContext mediationContext) {
        if (mediationContext == null) {
            throw new IllegalArgumentException("MediationContext can't be null");
        }
        this.mediationContext = mediationContext;
    }

    public MediationContext getMediationContext() {
        return this.mediationContext;
    }

    private int getCacheSize() {
        CacheSettings cs = this.getMediationContext().getWaterfallCacheSettings().get(this.getAdType());
        if (cs.getCacheSize() > 0) {
            return cs.getCacheSize();
        }
        return 2;
    }

    public int getHighestAvailableWeight() {
        for (int inx = 0; inx < this.adProvidersList.size(); ++inx) {
            InterstitialProvider providerInst = this.adProvidersList.get(inx);
            if (!providerInst.isAvailable(this.zoneToShow)) continue;
            return Integer.parseInt(providerInst.getProvider().getProviderWeight());
        }
        return 0;
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public boolean isAvailable(String adType, String zone) {
        if (this.isOnlyRTBWaterfall()) {
            return true;
        }
        for (int inx = 0; inx < this.adProvidersList.size(); ++inx) {
            InterstitialProvider providerInst = this.adProvidersList.get(inx);
            if (!adType.equals("interstitial") && !providerInst.getAdType().equals(adType) || !providerInst.isAvailable(zone)) continue;
            return true;
        }
        if (!this.allInitialized && this.loadedProviderCount == this.getCacheSize()) {
            this.loadedProviderCount = 0;
            this.startInitializationNextProvider();
        }
        return false;
    }

    public boolean isInitialized() {
        return this.adProvidersList.size() > 0;
    }

    public void showInterstitial(String zone) {
        if (!this.isInitializedWaiting) {
            this.displayInterstitial("interstitial", zone);
        }
    }

    public void showInterstitial(String adType, String zone) {
        if (!this.isInitializedWaiting) {
            this.displayInterstitial(adType, zone);
        }
    }

    private void displayInterstitial(String adType, String zone) {
        Activity activity;
        if (!this.isInitialized()) {
            this.tryShowWhenNotInitialized = true;
            this.zoneToShow = zone;
            this.sendLog(new SdkLog.Builder().format(adType).providerId(1).errorCode(72417).sessionId("2").build());
        }
        if ((activity = this.mediationContext.getActivity()) != null && !this.findProviderToShowAd(activity, adType, zone)) {
            boolean forceShow = true;
            if (this.mediationContext.getInterstitialListener() != null) {
                forceShow = this.mediationContext.getInterstitialListener().onInterstitialFailedToShow(adType);
            }
            if (forceShow && this.reservedProvider != null) {
                try {
                    if (this.reservedProvider.isRTB()) {
                        this.reservedProvider.initializeProviderSDK(activity, zone);
                        this.isInitializedWaiting = true;
                    } else {
                        this.reservedProvider.showAd(zone);
                    }
                    AdsATALog.i(String.format("#ADSMANAGER-INTERSTITIAL NOTIFICATION: %s AdProvider[reserved] =%s= show.", adType, this.reservedProvider.getProvider().getProviderName()));
                }
                catch (Exception e) {
                    AdsATALog.e(String.format("#ADSMANAGER-INTERSTITIAL NOTIFICATION: %s AdProvider[reserved] =%s= failed show: %s", adType, this.reservedProvider.getProvider().getProviderName(), e.getMessage()));
                }
            }
        }
    }

    protected boolean findProviderToShowAd(Activity activity, String adType, String zone) {
        return this.findProviderToShowAd(activity, adType, zone, true);
    }

    protected boolean findProviderToShowAd(Activity activity, String adType, String zone, boolean withLimit) {
        this.isWithLimit = withLimit;
        if (this.adProvidersList.size() > 0) {
            if (this.adProvidersList.size() <= this.adProviderIndex) {
                this.adProviderIndex = 0;
                if (!this.allInitialized && this.loadedProviderCount == this.getCacheSize()) {
                    this.loadedProviderCount = 0;
                    this.startInitializationNextProvider();
                }
                AdsATALog.i(String.format("#ADSMANAGER-INTERSTITIAL NOTIFICATION: There is no available %s AdProvider. Probably was initialized wrong adType.", adType));
                this.sendLog(new SdkLog.Builder().format(adType).sessionId(this.sessionId).waterfallIndex(-2).providerId(1).zone(zone).errorCode(72414).build());
                return false;
            }
            InterstitialProvider providerInst = this.adProvidersList.get(this.adProviderIndex);
            if (adType.equals("interstitial") || providerInst.getAdType().equals(adType)) {
                if (providerInst.isRTB()) {
                    this.isInitializedWaiting = true;
                    providerInst.initializeProviderSDK(activity, zone);
                    return true;
                }
                if (providerInst.isAvailable(zone) && (providerInst.getProvider().shouldShow() || !this.isWithLimit)) {
                    this.tryShowWhenNotInitialized = false;
                    this.isShowing = true;
                    providerInst.showAd(zone);
                    providerInst.getProvider().incShow();
                    AdsATALog.i(String.format("#ADSMANAGER-INTERSTITIAL NOTIFICATION: %s AdProvider[%d] =%s= show.", adType, this.adProviderIndex, providerInst.getProvider().getProviderName()));
                    this.sendLog(new SdkLog.Builder().format(adType).sessionId(this.sessionId).isOK(true).waterfallIndex(this.adProviderIndex).providerId(Integer.parseInt(providerInst.getProvider().getProviderId())).rtbProviderId(providerInst.getRtbProviderId()).zone(zone).build());
                    this.reservedProvider = providerInst;
                    if (!this.allInitialized && this.loadedProviderCount == this.getCacheSize() && this.adProviderIndex == this.adProvidersList.size() - 1) {
                        this.loadedProviderCount = 1;
                        this.startInitializationNextProvider();
                    }
                    this.adProviderIndex = 0;
                    return true;
                }
                providerInst.initializeProviderSDK(activity, null);
                this.sendLog(new SdkLog.Builder().format(adType).sessionId(this.sessionId).waterfallIndex(this.adProviderIndex).providerId(Integer.parseInt(providerInst.getProvider().getProviderId())).rtbProviderId(providerInst.getRtbProviderId()).zone(zone).errorCode(72414).build());
                ++this.adProviderIndex;
                if (this.isWithLimit && this.adProviderIndex >= this.adProvidersList.size()) {
                    this.adProviderIndex = 0;
                    this.resetBan();
                    return this.findProviderToShowAd(activity, adType, zone, false);
                }
                return this.findProviderToShowAd(activity, adType, zone, this.isWithLimit);
            }
            ++this.adProviderIndex;
            return this.findProviderToShowAd(activity, adType, zone, withLimit);
        }
        AdsATALog.i(String.format("#ADSMANAGER-INTERSTITIAL NOTIFICATION: There is no ready %s AdProviders. Please check AdCel.isAvailableAd(AdCel.%s) method or use callbacks.", adType, adType.toUpperCase()));
        this.sendLog(new SdkLog.Builder().sessionId(this.sessionId).format(adType).providerId(1).zone(zone).errorCode(72416).build());
        return false;
    }

    private void resetBan() {
        for (int inx = 0; inx < this.adProvidersList.size(); ++inx) {
            this.adProvidersList.get(inx).getProvider().resetBan();
        }
    }

    protected void providerLoadedSuccess(InterstitialProvider provider, String adType) {
        ++this.loadedProviderCount;
        if (this.tryShowWhenNotInitialized && !this.isShowing()) {
            this.displayInterstitial(adType, this.zoneToShow);
        }
        if (this.loadedProviderCount < this.getCacheSize()) {
            this.startInitializationNextProvider();
        }
        AdsATALog.i(String.format("#ADSMANAGER-INTERSTITIAL NOTIFICATION: %sProvider %s loaded success.", adType, provider.getProvider().getProviderName()));
        this.reservedProvider = provider;
    }

    void startInitializationNextProvider() {
        this.startInitializationNextProvider(true);
    }

    void startInitializationNextProvider(boolean onlyNotSterted) {
        Activity activity = this.mediationContext.getActivity();
        if (activity == null || this.allInitialized) {
            return;
        }
        boolean forceInit = false;
        for (int inx = 0; inx < this.adProvidersList.size(); ++inx) {
            InterstitialProvider providerInst = this.adProvidersList.get(inx);
            if (providerInst.isRTB()) {
                ++this.rtbProviderCount;
                continue;
            }
            if (providerInst.getInitializationState() == 0 || !onlyNotSterted) {
                providerInst.initializeProviderSDK(activity, null);
                if (inx != this.adProvidersList.size() - 1) break;
                this.allInitialized = true;
                break;
            }
            if (inx != this.adProvidersList.size() - 1) continue;
            forceInit = true;
        }
        if (this.isOnlyRTBWaterfall()) {
            this.allInitialized = true;
        }
        if (forceInit && onlyNotSterted) {
            this.startInitializationNextProvider(false);
        }
    }

    public void createProviderPriorityLists(String adType, InterstitialAdProviderPopulateAdapter populateAdapter, boolean startCachingImmediately) {
        AdsATALog.i(String.format("AdCelSDK: %s module initialization started.", adType));
        try {
            this.mAdType = adType;
            this.adProviderIndex = 0;
            this.rtbProviderCount = 0;
            this.adProvidersList = new ArrayList<InterstitialProvider>();
            populateAdapter.populate(this.adProvidersList, this);
            if (this.adProvidersList.size() > 0) {
                this.reservedProvider = this.adProvidersList.get(0);
                this.sessionId = this.mediationContext.generateSessionId(this.getAdType());
                if (startCachingImmediately) {
                    this.initializeAllProviders();
                }
                AdsATALog.i(String.format("==========\nAdCelSDK: Instantiating %sProvider with the highest eCPM...", adType));
            } else {
                AdsATALog.i(String.format("#ADSMANAGER-INTERSTITIAL NOTIFICATION: There is no available %s AdProvider for further initialization.", adType));
                this.notifyInterstitialLoadFail();
            }
        }
        catch (NullPointerException e) {
            AdsATALog.i(String.format("#ADSMANAGER-INTERSTITIAL NOTIFICATION: There is no available %s AdProvider for further initialization.", adType));
            this.notifyInterstitialLoadFail();
        }
    }

    public boolean isInitializationStarted() {
        return this.initializationStarted;
    }

    public void stop() {
        this.initializationStarted = false;
        this.firstAdLoad = true;
        this.adProviderIndex = 0;
        this.reservedProvider = null;
        this.allInitialized = false;
        this.loadedProviderCount = 0;
        this.rtbProviderCount = 0;
        this.tryShowWhenNotInitialized = false;
        for (int inx = 0; inx < this.adProvidersList.size(); ++inx) {
            InterstitialProvider providerInst = this.adProvidersList.get(inx);
            providerInst.stop();
        }
    }

    public void initializeAllProviders() {
        this.initializationStarted = true;
        this.startInitializationNextProvider();
        if (!this.isOnlyRTBWaterfall()) {
            this.checkInitialization();
        }
    }

    void checkInitialization() {
        if (this.checkInitializationWorker == null) {
            this.checkInitializationWorker = Executors.newSingleThreadScheduledExecutor();
        }
        if (this.checkInitializationFuture != null) {
            return;
        }
        this.checkInitializationFuture = this.checkInitializationWorker.schedule(new Runnable(){

            @Override
            public void run() {
                InterstitialAdsManager.this.checkInitializationFuture = null;
                if (InterstitialAdsManager.this.loadedProviderCount == 0) {
                    if (InterstitialAdsManager.this.allInitialized && !InterstitialAdsManager.this.isAvailable(InterstitialAdsManager.this.mAdType, InterstitialAdsManager.this.zoneToShow)) {
                        InterstitialAdsManager.this.notifyInterstitialLoadFail();
                        InterstitialAdsManager.this.allInitialized = false;
                    }
                    InterstitialAdsManager.this.startInitializationNextProvider();
                    InterstitialAdsManager.this.checkInitialization();
                }
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public void updateProvidersSDK(ProviderUpdateAction action, Activity activity) {
        if (!this.initializationStarted) {
            return;
        }
        AdsATALog.i("AdCelSDK: " + this.getClass().getName() + ".updateProvidersSDK(" + (Object)((Object)action) + ")");
        if (action != ProviderUpdateAction.RESUME) {
            this.tryShowWhenNotInitialized = false;
        }
        for (int inx = 0; inx < this.adProvidersList.size(); ++inx) {
            InterstitialProvider providerInst = this.adProvidersList.get(inx);
            if (providerInst.getInitializationState() == 0) continue;
            providerInst.updateProviderSDK(action, activity);
        }
    }

    protected void initializeProviderCrash(InterstitialProvider providerInst) {
        AdsATALog.i(String.format("#ADSMANAGER-INTERSTITIAL NOTIFICATION: Provider %s initialize crash.", providerInst.getProvider().getProviderName()));
        if (providerInst != null && providerInst.getProvider() != null) {
            this.sendLog(new SdkLog.Builder().format(this.getAdType()).sessionId("I").waterfallIndex(-3).providerId(Integer.parseInt(providerInst.getProvider().getProviderId())).rtbProviderId(providerInst.getRtbProviderId()).errorCode(72418).build());
        }
    }

    public void dismiss() {
        if (this.reservedProvider != null) {
            this.reservedProvider.dismiss();
        }
    }

    protected boolean isFirstAdLoad() {
        return this.firstAdLoad;
    }

    protected void notifyFirstInterstitialLoad(final String provider) {
        if (!this.initializationStarted) {
            return;
        }
        this.firstAdLoad = false;
        Activity activity = this.mediationContext.getActivity();
        if (this.mediationContext.getInterstitialListener() != null && activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    InterstitialAdsManager.this.mediationContext.getInterstitialListener().onFirstInterstitialLoad(InterstitialAdsManager.this.mAdType, provider);
                }
            });
        }
    }

    protected void notifyInterstitialLoadFail() {
        if (!this.initializationStarted) {
            return;
        }
        Activity activity = this.mediationContext.getActivity();
        if (this.mediationContext.getInterstitialListener() != null && activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    InterstitialAdsManager.this.mediationContext.getInterstitialListener().onInterstitialFailLoad(InterstitialAdsManager.this.mAdType, "No Fill");
                }
            });
        }
    }

    protected void notifyInterstitialStarted(final String adType, final String provider) {
        Activity activity = this.mediationContext.getActivity();
        if (this.mediationContext.getInterstitialListener() != null && activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    InterstitialAdsManager.this.mediationContext.getInterstitialListener().onInterstitialStarted(adType, provider);
                }
            });
        }
    }

    protected void notifyInterstitialClicked(final InterstitialProvider providerInst) {
        Activity activity = this.mediationContext.getActivity();
        if (this.mediationContext.getInterstitialListener() != null && activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    InterstitialAdsManager.this.sendLog(new SdkLog.Builder().format(InterstitialAdsManager.this.getAdType()).sessionId(InterstitialAdsManager.this.sessionId).isOK(true).isClicked(true).waterfallIndex(InterstitialAdsManager.this.adProviderIndex).providerId(Integer.parseInt(providerInst.getProvider().getProviderId())).rtbProviderId(providerInst.getRtbProviderId()).zone(InterstitialAdsManager.this.zoneToShow).build());
                    InterstitialAdsManager.this.mediationContext.getInterstitialListener().onInterstitialClicked(providerInst.getAdType(), providerInst.getProvider().getProviderName());
                }
            });
        }
    }

    protected void notifyInterstitialClosed(final String adType, final String provider) {
        this.sessionId = this.mediationContext.generateSessionId(this.getAdType());
        this.isShowing = false;
        Activity activity = this.mediationContext.getActivity();
        if (this.mediationContext.getInterstitialListener() != null && activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    InterstitialAdsManager.this.mediationContext.getInterstitialListener().onInterstitialClosed(adType, provider);
                }
            });
        }
    }

    public void notifyRewardedCompleted(final String adProvider) {
        Activity activity = this.mediationContext.getActivity();
        if (this.mediationContext.getInterstitialListener() != null && activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    RewardedAdValues currency = InterstitialAdsManager.this.mediationContext.getCurrencySettings();
                    InterstitialAdsManager.this.mediationContext.getInterstitialListener().onRewardedCompleted(adProvider, currency.getName(), currency.getValue());
                }
            });
        }
    }

    protected boolean isOnlyRTBWaterfall() {
        return this.rtbProviderCount == this.adProvidersList.size();
    }

    public void failureInitRTBProvider(Activity activity, InterstitialProvider providerInst, String adType) {
        this.isInitializedWaiting = false;
        this.sendLog(new SdkLog.Builder().format(adType).sessionId(this.sessionId).waterfallIndex(this.adProviderIndex).providerId(Integer.parseInt(providerInst.getProvider().getProviderId())).rtbProviderId(providerInst.getRtbProviderId()).zone(this.zoneToShow).errorCode(72414).build());
        ++this.adProviderIndex;
        if (this.isWithLimit && this.adProviderIndex >= this.adProvidersList.size()) {
            this.adProviderIndex = 0;
            this.resetBan();
            if (activity != null) {
                this.findProviderToShowAd(activity, adType, this.zoneToShow, false);
            }
        } else if (activity != null) {
            this.findProviderToShowAd(activity, adType, this.zoneToShow, this.isWithLimit);
        }
    }

    public void successInitRTBProvider(Activity activity, InterstitialProvider providerInst, String adType) {
        this.isInitializedWaiting = false;
        if (providerInst.isAvailable(this.zoneToShow) && (providerInst.getProvider().shouldShow() || !this.isWithLimit)) {
            this.tryShowWhenNotInitialized = false;
            this.isShowing = true;
            providerInst.showAd(this.zoneToShow);
            providerInst.getProvider().incShow();
            AdsATALog.i(String.format("#ADSMANAGER-INTERSTITIAL NOTIFICATION: %s AdProvider[%d] =%s= show.", adType, this.adProviderIndex, providerInst.getProvider().getProviderName()));
            this.sendLog(new SdkLog.Builder().format(adType).sessionId(this.sessionId).isOK(true).waterfallIndex(this.adProviderIndex).providerId(Integer.parseInt(providerInst.getProvider().getProviderId())).rtbProviderId(providerInst.getRtbProviderId()).build());
            this.reservedProvider = providerInst;
            if (!this.allInitialized && this.loadedProviderCount == this.getCacheSize() && this.adProviderIndex == this.adProvidersList.size() - 1) {
                this.loadedProviderCount = 1;
                this.startInitializationNextProvider();
            }
            this.adProviderIndex = 0;
        } else {
            this.failureInitRTBProvider(activity, providerInst, adType);
        }
    }

    private void sendLog(SdkLog sdkLog) {
        LogService logService = DefaultDependenciesFactory.logService();
        if (logService == null) {
            return;
        }
        logService.send(sdkLog);
    }
}

