/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.interstitialads;

import android.app.Activity;
import android.os.Build;
import co.adcel.common.AdProviderDTO;
import co.adcel.interstitialads.InterstitialAdsManager;
import co.adcel.interstitialads.InterstitialListener;
import co.adcel.interstitialads.InterstitialProvider;
import co.adcel.logger.AdsATALog;
import java.lang.ref.WeakReference;
import java.util.Map;

public abstract class InterstitialProviderBase
implements InterstitialProvider {
    protected Map<String, AdProviderDTO> provider;
    protected AdProviderDTO providerDTO;
    private WeakReference<Activity> mActivity = new WeakReference<Object>(null);
    protected InterstitialAdsManager interstitialAdsManager;
    protected String mAdType = "interstitial";
    protected int initializationState = 0;

    protected InterstitialProviderBase(String adType, Map<String, AdProviderDTO> provider, InterstitialAdsManager interstitialAdsManager) {
        this.mAdType = adType;
        this.provider = provider;
        this.providerDTO = provider.get(adType);
        this.interstitialAdsManager = interstitialAdsManager;
    }

    @Override
    public AdProviderDTO getProvider() {
        return this.providerDTO;
    }

    @Override
    public boolean isAvailable(String zone) {
        return this.initializationState == 3;
    }

    @Override
    public void initializeProviderSDK(final Activity activity, final String zone) {
        this.mActivity = new WeakReference<Activity>(activity);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    if (Build.VERSION.SDK_INT < InterstitialProviderBase.this.getMinAndroidApiVer()) {
                        InterstitialProviderBase.this.loadFail(String.format("%s support only android api %s or higher", InterstitialProviderBase.this.getProvider().getProviderName(), String.valueOf(InterstitialProviderBase.this.getMinAndroidApiVer())));
                        return;
                    }
                    try {
                        InterstitialProviderBase.this.init(activity, zone);
                        AdsATALog.i(String.format("#PROVIDER =%s=(%s) INSTANTIATED", InterstitialProviderBase.this.getProvider().getProviderName(), InterstitialProviderBase.this.mAdType));
                        if (InterstitialProviderBase.this.initializationState == 0) {
                            InterstitialProviderBase.this.initializationState = 1;
                        }
                    }
                    catch (Exception e) {
                        InterstitialProviderBase.this.interstitialAdsManager.initializeProviderCrash(InterstitialProviderBase.this);
                        if (InterstitialProviderBase.this.initializationState != 2) {
                            InterstitialProviderBase.this.initializationState = 2;
                            InterstitialProviderBase.this.interstitialAdsManager.startInitializationNextProvider();
                        }
                    }
                    catch (Error e) {
                        InterstitialProviderBase.this.interstitialAdsManager.initializeProviderCrash(InterstitialProviderBase.this);
                        if (InterstitialProviderBase.this.initializationState == 2) break block6;
                        InterstitialProviderBase.this.initializationState = 2;
                        InterstitialProviderBase.this.interstitialAdsManager.startInitializationNextProvider();
                    }
                }
            }
        });
    }

    protected abstract void init(Activity var1, String var2);

    @Override
    public boolean isRTB() {
        return false;
    }

    @Override
    public String getAdType() {
        return this.mAdType;
    }

    @Override
    public int getInitializationState() {
        return this.initializationState;
    }

    @Override
    public int getRtbProviderId() {
        return 0;
    }

    @Override
    public int getMinAndroidApiVer() {
        return 14;
    }

    protected void loadSuccess() {
        this.initializationState = 3;
        this.interstitialAdsManager.providerLoadedSuccess(this, this.mAdType);
        AdsATALog.i(String.format("#PROVIDER =%s=(%s) AD AVAILABLE ", this.getProvider().getProviderName(), this.mAdType));
        if (this.interstitialAdsManager.isFirstAdLoad()) {
            this.interstitialAdsManager.notifyFirstInterstitialLoad(this.getProvider().getProviderName());
        }
    }

    protected void loadFail(String error) {
        if (this.initializationState != 2) {
            this.initializationState = 2;
            this.interstitialAdsManager.startInitializationNextProvider();
        }
        AdsATALog.i(String.format("#PROVIDER =%s=(%s) AD UNAVAILABLE. Error code: %s", this.getProvider().getProviderName(), this.mAdType, error));
    }

    protected void start() {
        this.interstitialAdsManager.notifyInterstitialStarted(this.mAdType, this.getProvider().getProviderName());
    }

    protected void close() {
        this.interstitialAdsManager.notifyInterstitialClosed(this.mAdType, this.getProvider().getProviderName());
    }

    protected void click() {
        this.interstitialAdsManager.notifyInterstitialClicked(this);
    }

    protected void rewardComplete() {
        this.interstitialAdsManager.notifyRewardedCompleted(this.getProvider().getProviderName());
    }

    protected void showFailed() {
        InterstitialListener interstitialListener = this.interstitialAdsManager.getMediationContext().getInterstitialListener();
        if (interstitialListener != null) {
            interstitialListener.onInterstitialFailedToShow(this.mAdType);
        }
    }

    @Override
    public void dismiss() {
    }

    public void successInitRTBProvider() {
        this.loadSuccess();
        this.interstitialAdsManager.successInitRTBProvider((Activity)this.mActivity.get(), this, this.mAdType);
    }

    public void failureInitRTBProvider(String error) {
        this.loadFail(error);
        this.interstitialAdsManager.failureInitRTBProvider((Activity)this.mActivity.get(), this, this.mAdType);
    }
}

