/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.interstitialads;

import android.app.Activity;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.ads.rtb.InterstitialAdEventListener;
import co.adcel.common.AdProviderDTO;
import co.adcel.common.GDPRUserConsent;
import co.adcel.common.ProviderUpdateAction;
import co.adcel.inhouse.InterstitialAd;
import co.adcel.interstitialads.InterstitialAdsManager;
import co.adcel.interstitialads.InterstitialProviderBase;
import java.util.Map;

public class ProviderInHouse
extends InterstitialProviderBase
implements InterstitialAdEventListener {
    protected InterstitialAd mInterstitialAd = null;

    static boolean isProviderInstalled() {
        try {
            Class.forName("co.adcel.inhouse.InterstitialAd");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public ProviderInHouse(String adType, Map<String, AdProviderDTO> provider, InterstitialAdsManager interstitialAdsManager) {
        super(adType, provider, interstitialAdsManager);
    }

    @Override
    public boolean isAvailable(String zone) {
        return super.isAvailable(zone) && this.mInterstitialAd != null && this.mInterstitialAd.isReadyToShow();
    }

    @Override
    protected void init(Activity activity, String zone) {
        if (this.mInterstitialAd == null) {
            this.mInterstitialAd = new InterstitialAd(activity, this.getAdType(), this);
            MediationContext mediationContext = this.interstitialAdsManager.getMediationContext();
            if (mediationContext.isGDPRApplicable()) {
                this.mInterstitialAd.setGdprConsent(mediationContext.getGdprUserConsent() != GDPRUserConsent.NOT_CONSENT);
            }
        }
    }

    @Override
    public void showAd(String zone) {
        if (this.mInterstitialAd == null) {
            this.showFailed();
            return;
        }
        this.mInterstitialAd.showAd();
    }

    @Override
    public void updateProviderSDK(ProviderUpdateAction action, Activity activity) {
        if (this.mInterstitialAd == null) {
            return;
        }
        switch (action) {
            case RESUME: {
                this.mInterstitialAd.resume(activity);
            }
        }
    }

    @Override
    public void stop() {
        this.mInterstitialAd = null;
    }

    @Override
    public void onAdLoadSuccess(int providerId) {
        this.loadSuccess();
    }

    @Override
    public void onAdLoadFailure(String error) {
        this.loadFail(error);
    }

    @Override
    public void onAdShow() {
        this.start();
    }

    @Override
    public void onAdClick() {
        this.click();
    }

    @Override
    public void onAdClose() {
        this.close();
    }

    @Override
    public void onAdShowFailed() {
        this.showFailed();
    }

    @Override
    public void onAdRewardComplete() {
        this.rewardComplete();
    }
}

