/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.interstitialads;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class SingleListenerAdapterBase {
    protected static SingleListenerAdapterBase instance;
    private List<WeakReference<OnSingleListenerLoadEvents>> onLoadEventsListeners = new ArrayList<WeakReference<OnSingleListenerLoadEvents>>();
    private WeakReference<OnSingleListenerShowEvents> onSingleListenerShowEventsWeakReference;

    public static <T extends SingleListenerAdapterBase> T getInstance(Class<T> clazz) {
        SingleListenerAdapterBase inst = null;
        try {
            Field field = clazz.getDeclaredField("instance");
            inst = (SingleListenerAdapterBase)field.get(null);
            if (inst == null) {
                try {
                    inst = (SingleListenerAdapterBase)clazz.newInstance();
                    field.set(null, inst);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return (T)inst;
    }

    protected SingleListenerAdapterBase() {
    }

    public void addLoadEventsListener(OnSingleListenerLoadEvents onLoadEventsListener) {
        for (int i = 0; i < this.onLoadEventsListeners.size(); ++i) {
            WeakReference<OnSingleListenerLoadEvents> refLsnr = this.onLoadEventsListeners.get(i);
            OnSingleListenerLoadEvents lsnr = (OnSingleListenerLoadEvents)refLsnr.get();
            if (lsnr == null || !lsnr.equals(onLoadEventsListener)) continue;
            return;
        }
        this.onLoadEventsListeners.add(new WeakReference<OnSingleListenerLoadEvents>(onLoadEventsListener));
    }

    public void removeLoadEventsListener(OnSingleListenerLoadEvents onLoadEventsListener) {
        for (int i = 0; i < this.onLoadEventsListeners.size(); ++i) {
            WeakReference<OnSingleListenerLoadEvents> refLsnr = this.onLoadEventsListeners.get(i);
            OnSingleListenerLoadEvents lsnr = (OnSingleListenerLoadEvents)refLsnr.get();
            if (lsnr == null || !lsnr.equals(onLoadEventsListener)) continue;
            this.onLoadEventsListeners.remove(refLsnr);
            return;
        }
    }

    public void show(OnSingleListenerShowEvents onSingleListenerShowEvents) {
        this.onSingleListenerShowEventsWeakReference = new WeakReference<OnSingleListenerShowEvents>(onSingleListenerShowEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLoadEventsListeners(OnNotifyLoadEvents action) {
        SingleListenerAdapterBase singleListenerAdapterBase = this;
        synchronized (singleListenerAdapterBase) {
            int i;
            ArrayList<Integer> idxForDelete = new ArrayList<Integer>();
            for (i = 0; i < this.onLoadEventsListeners.size(); ++i) {
                WeakReference<OnSingleListenerLoadEvents> refLsnr = this.onLoadEventsListeners.get(i);
                OnSingleListenerLoadEvents lsnr = (OnSingleListenerLoadEvents)refLsnr.get();
                if (lsnr != null) {
                    action.onNotifyLoadEvents(lsnr);
                    continue;
                }
                idxForDelete.add(i);
            }
            for (i = 0; i < idxForDelete.size(); ++i) {
                if (i >= this.onLoadEventsListeners.size()) continue;
                this.onLoadEventsListeners.remove(i);
            }
        }
    }

    protected void loadSuccess() {
        this.notifyLoadEventsListeners(new OnNotifyLoadEvents(){

            @Override
            public void onNotifyLoadEvents(OnSingleListenerLoadEvents listener) {
                listener.onLoadSuccess();
            }
        });
    }

    protected void loadFail(final String error) {
        this.notifyLoadEventsListeners(new OnNotifyLoadEvents(){

            @Override
            public void onNotifyLoadEvents(OnSingleListenerLoadEvents listener) {
                listener.onLoadFail(error);
            }
        });
    }

    protected void start() {
        if (this.onSingleListenerShowEventsWeakReference == null) {
            return;
        }
        OnSingleListenerShowEvents lsnr = (OnSingleListenerShowEvents)this.onSingleListenerShowEventsWeakReference.get();
        if (lsnr != null) {
            lsnr.onStart();
        }
    }

    protected void close() {
        if (this.onSingleListenerShowEventsWeakReference == null) {
            return;
        }
        OnSingleListenerShowEvents lsnr = (OnSingleListenerShowEvents)this.onSingleListenerShowEventsWeakReference.get();
        if (lsnr != null) {
            lsnr.onClose();
        }
        this.onSingleListenerShowEventsWeakReference = null;
    }

    protected void click() {
        if (this.onSingleListenerShowEventsWeakReference == null) {
            return;
        }
        OnSingleListenerShowEvents lsnr = (OnSingleListenerShowEvents)this.onSingleListenerShowEventsWeakReference.get();
        if (lsnr != null) {
            lsnr.onClick();
        }
    }

    protected void rewardComplete() {
        if (this.onSingleListenerShowEventsWeakReference == null) {
            return;
        }
        OnSingleListenerShowEvents lsnr = (OnSingleListenerShowEvents)this.onSingleListenerShowEventsWeakReference.get();
        if (lsnr != null) {
            lsnr.onRewardComplete();
        }
    }

    protected void showFailed() {
        if (this.onSingleListenerShowEventsWeakReference == null) {
            return;
        }
        OnSingleListenerShowEvents lsnr = (OnSingleListenerShowEvents)this.onSingleListenerShowEventsWeakReference.get();
        if (lsnr != null) {
            lsnr.onShowFailed();
        }
    }

    static interface OnNotifyLoadEvents {
        public void onNotifyLoadEvents(OnSingleListenerLoadEvents var1);
    }

    public static interface OnSingleListenerShowEvents {
        public void onStart();

        public void onClose();

        public void onClick();

        public void onRewardComplete();

        public void onShowFailed();
    }

    public static interface OnSingleListenerLoadEvents {
        public void onLoadSuccess();

        public void onLoadFail(String var1);
    }
}

