/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.logger;

import android.util.Log;
import co.adcel.logger.LogEventListener;

public final class AdsATALog {
    private static String TAG = "AdCel-1.12.4";
    public static boolean logEnabled = false;
    public static int lowestLevel = 4;
    private static LogEventListener logEventListener;

    public static void setLogEventListener(LogEventListener logEventListener) {
        AdsATALog.logEventListener = logEventListener;
    }

    public static void logLongText(String text) {
        if (logEnabled && lowestLevel >= 2) {
            while (text.length() > 0) {
                if (text.length() > 1000) {
                    String firstSymbols = text.substring(0, 1000);
                    text = text.substring(1000, text.length());
                    AdsATALog.v(firstSymbols);
                    continue;
                }
                AdsATALog.v(text);
                text = "";
            }
        }
    }

    public static void setLogEnabled(boolean enabled) {
        logEnabled = enabled;
    }

    public static void setLogLevel(int logLevel) {
        logEnabled = logLevel != 0;
        lowestLevel = logLevel;
    }

    public static void d(String msg) {
        AdsATALog.d(msg, null);
    }

    public static void e(String msg) {
        AdsATALog.e(msg, null);
    }

    public static void i(String msg) {
        AdsATALog.i(msg, null);
    }

    public static void w(String msg) {
        AdsATALog.w(msg, null);
    }

    public static void v(String msg) {
        AdsATALog.v(msg, null);
    }

    public static void d(String msg, Throwable t) {
        if (logEventListener != null) {
            logEventListener.onLogD(msg, t);
        }
        if (logEnabled && lowestLevel <= 3) {
            Log.d((String)TAG, (String)msg, (Throwable)t);
        }
    }

    public static void e(String msg, Throwable t) {
        if (logEventListener != null) {
            logEventListener.onLogE(msg, t);
        }
        if (logEnabled && lowestLevel <= 6) {
            Log.e((String)TAG, (String)msg, (Throwable)t);
        }
    }

    public static void i(String msg, Throwable t) {
        if (logEventListener != null) {
            logEventListener.onLogI(msg, t);
        }
        if (logEnabled && lowestLevel <= 4) {
            Log.i((String)TAG, (String)msg, (Throwable)t);
        }
    }

    public static void w(String msg, Throwable t) {
        if (logEventListener != null) {
            logEventListener.onLogW(msg, t);
        }
        if (logEnabled && lowestLevel <= 5) {
            Log.w((String)TAG, (String)msg, (Throwable)t);
        }
    }

    public static void v(String msg, Throwable t) {
        if (logEventListener != null) {
            logEventListener.onLogV(msg, t);
        }
        if (logEnabled && lowestLevel <= 2) {
            Log.v((String)TAG, (String)msg, (Throwable)t);
        }
    }
}

