/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.nativeads;

import android.content.Context;
import android.os.Handler;
import co.adcel.ads.mediation.DefaultDependenciesFactory;
import co.adcel.ads.mediation.LogService;
import co.adcel.ads.mediation.SdkLog;
import co.adcel.common.AdProviderDTO;
import co.adcel.init.AdCel;
import co.adcel.logger.AdsATALog;
import co.adcel.nativeads.NativeAd;
import co.adcel.nativeads.NativeAdProvider;
import co.adcel.nativeads.NativeAdsManager;
import co.adcel.nativeads.TestNativeAd;
import java.util.ArrayList;
import java.util.List;

public final class AdCelNative
implements NativeAdProvider.OnAdLoadListener,
NativeAdProvider.OnAdClickListener {
    public static final int MAX_ATTEMPT_COUNT = 5;
    private static List<AdCelNative> adRequests = new ArrayList<AdCelNative>();
    private NativeAdsManager nativeAdsManager;
    private AdLoadListener adLoadListener;
    private List<String> queue;
    private int currentProviderIndex;
    private int lastLoadedProviderIndex;
    private Context context;
    private int count;
    private boolean random;
    private boolean async;
    private List<NativeAd> ads = new ArrayList<NativeAd>();
    int attemptCount = 0;
    private String sessionId = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadAd(NativeAdsManager nativeAdsManager, Context context, int count, boolean random, boolean async, AdLoadListener adLoadListener) {
        if (!nativeAdsManager.isInitialized()) {
            AdsATALog.i("#AdCelNative NOTIFICATION: There is no available Native AdProvider. Probably you didn't initialize this adType.");
            return;
        }
        List<String> queue = nativeAdsManager.getProviderQueue();
        if (queue.size() == 0) {
            AdsATALog.i("#AdCelNative NOTIFICATION: There is no available Native AdProvider. Probably you didn't initialize this adType.");
            return;
        }
        AdCelNative adapter = new AdCelNative(nativeAdsManager, context, queue, count, random, async, adLoadListener);
        List<AdCelNative> list = adRequests;
        synchronized (list) {
            adRequests.add(adapter);
        }
        AdsATALog.i(String.format("#AdCelNative: Start loading %s providers, count=%d, random=%b, async=%b", queue.size(), count, random, async));
        adapter.makeStep(Action.RETRY_SAME_PROVIDER);
    }

    private AdCelNative(NativeAdsManager nativeAdsManager, Context context, List<String> queue, int count, boolean random, boolean async, AdLoadListener adLoadListener) {
        this.nativeAdsManager = nativeAdsManager;
        this.context = context;
        this.queue = queue;
        this.count = count;
        this.random = random;
        this.async = async;
        this.adLoadListener = adLoadListener;
        this.sessionId = nativeAdsManager.getMediationContext().generateSessionId("native");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompletion() {
        List<AdCelNative> list = adRequests;
        synchronized (list) {
            adRequests.remove(this);
            System.gc();
        }
    }

    private boolean isCompleted() {
        return !adRequests.contains(this);
    }

    private void loadAd() {
        if (AdCel.isTestModeEnabled()) {
            if (this.async) {
                for (int i = 0; i < this.count; ++i) {
                    ArrayList<NativeAd> testAds = new ArrayList<NativeAd>();
                    TestNativeAd ad = new TestNativeAd(this.context);
                    testAds.add(ad);
                    if (this.adLoadListener == null) continue;
                    this.adLoadListener.onLoadAd(testAds, "test");
                }
            } else {
                ArrayList<NativeAd> testAds = new ArrayList<NativeAd>();
                for (int i = 0; i < this.count; ++i) {
                    TestNativeAd ad = new TestNativeAd(this.context);
                    testAds.add(ad);
                }
                if (this.adLoadListener != null) {
                    this.adLoadListener.onLoadAd(testAds, "test");
                }
            }
            return;
        }
        if (this.queue.size() <= this.currentProviderIndex) {
            this.currentProviderIndex = 0;
            if (this.attemptCount >= 5 || this.count == 1 && this.ads.size() == 0) {
                if (this.ads.size() > 0 && this.adLoadListener != null) {
                    this.adLoadListener.onLoadAd(this.ads, "");
                } else {
                    this.notifyFailLoadAdAllProviders();
                }
                this.onCompletion();
                return;
            }
            ++this.attemptCount;
        }
        String providerName = this.queue.get(this.currentProviderIndex);
        AdsATALog.i(String.format("#AdCelNative: Selected provider %s", providerName));
        NativeAdProvider provider = this.sharedProvider(providerName);
        boolean skipRTB = false;
        if (this.adLoadListener != null) {
            skipRTB = this.adLoadListener.onShouldSkipRTBProviders();
        }
        if (provider == null) {
            AdsATALog.i(String.format("#AdCelNative: Unreachable provider %s", providerName));
            AdsATALog.i("#AdCelNative: Trying NEXT one");
            this.makeStep(Action.TRY_NEXT_PROVIDER);
        } else if (provider.isRTB() && skipRTB) {
            AdsATALog.i(String.format("#AdCelNative: RTB Provider Skiped by DELEGATE >> id = %s", providerName));
            AdsATALog.i("#AdCelNative: Trying NEXT one");
            this.makeStep(Action.TRY_NEXT_PROVIDER);
        } else {
            AdsATALog.i(String.format("#AdCelNative: REQUEST ADS on provider %s", providerName));
            provider.loadAd(this.count - this.ads.size());
        }
    }

    private void makeStep(Action action) {
        switch (action) {
            case RETRY_SAME_PROVIDER: {
                ++this.attemptCount;
                this.loadAd();
                break;
            }
            case TRY_NEXT_PROVIDER: {
                ++this.currentProviderIndex;
                this.loadAd();
                break;
            }
            default: {
                this.onCompletion();
            }
        }
    }

    @Override
    public void onLoadAdSuccess(final List<NativeAd> nativeAds, final NativeAdProvider provider) {
        if (this.isCompleted()) {
            return;
        }
        provider.setOnAdClickListener(this);
        if (nativeAds != null) {
            this.lastLoadedProviderIndex = this.currentProviderIndex;
            new Handler(this.context.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    AdCelNative.this.sendLog(new SdkLog.Builder().format("native").sessionId(AdCelNative.this.sessionId).isOK(true).waterfallIndex(AdCelNative.this.currentProviderIndex).providerId(provider.getProviderId()).rtbProviderId(provider.getRtbProviderId()).build());
                    AdCelNative.this.notifyLoadAd(nativeAds);
                }
            });
        } else {
            this.onLoadAdFailed("ERROR parsing received Ad", provider);
        }
    }

    @Override
    public void onLoadAdFailed(final String error, final NativeAdProvider provider) {
        if (this.isCompleted()) {
            return;
        }
        new Handler(this.context.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                AdCelNative.this.sendLog(new SdkLog.Builder().format("native").sessionId(AdCelNative.this.sessionId).waterfallIndex(AdCelNative.this.currentProviderIndex).providerId(provider.getProviderId()).rtbProviderId(provider.getRtbProviderId()).errorCode(72414).build());
                Action action = AdCelNative.this.notifyFailLoadAd(error);
                AdCelNative.this.makeStep(action);
            }
        });
    }

    @Override
    public void onAdClick(NativeAdProvider provider) {
        this.sendLog(new SdkLog.Builder().format("native").sessionId(this.sessionId).isOK(true).isClicked(true).waterfallIndex(this.currentProviderIndex).providerId(provider.getProviderId()).rtbProviderId(provider.getRtbProviderId()).build());
    }

    private NativeAdProvider sharedProvider(String providerName) {
        AdProviderDTO provider = this.nativeAdsManager.getMediationContext().getProvider(this.queue.get(this.currentProviderIndex), "native");
        AdsATALog.i(String.format("#AdCelNative: init provider %s: %s", provider.getProviderName(), provider.getProviderECPM()));
        return this.nativeAdsManager.getProvider(this.context, provider, this);
    }

    private void notifyLoadAd(List<NativeAd> nativeAds) {
        String providerName = "";
        if (this.currentProviderIndex < this.queue.size()) {
            providerName = this.queue.get(this.currentProviderIndex);
        } else {
            AdsATALog.i(String.format("#AdCelNative: Current Provider Index = %s is not in Providers Queue range = {0,%s}", this.currentProviderIndex, this.queue.size()));
        }
        AdsATALog.i(String.format("#AdCelNative: Did load ad >> provider id %s", providerName));
        this.ads.addAll(nativeAds);
        if (this.async) {
            if (this.adLoadListener != null) {
                this.adLoadListener.onLoadAd(nativeAds, providerName);
            }
            if (this.ads.size() < this.count) {
                if (this.random) {
                    this.makeStep(Action.TRY_NEXT_PROVIDER);
                } else {
                    this.currentProviderIndex = 0;
                    this.loadAd();
                }
            } else {
                this.onCompletion();
            }
        } else if (!this.async && this.ads.size() < this.count) {
            if (this.random) {
                this.makeStep(Action.TRY_NEXT_PROVIDER);
            } else {
                this.currentProviderIndex = 0;
                this.loadAd();
            }
        } else if (this.adLoadListener != null) {
            this.adLoadListener.onLoadAd(this.ads, providerName);
            this.onCompletion();
        }
    }

    private Action notifyFailLoadAd(String error) {
        String providerName = "";
        if (this.currentProviderIndex < this.queue.size()) {
            providerName = this.queue.get(this.currentProviderIndex);
        } else {
            AdsATALog.i(String.format("#AdCelNative: Current Provider Index = %s is not in Providers Queue range = {0,%s}", this.currentProviderIndex, this.queue.size()));
        }
        AdsATALog.i(String.format("#AdCelNative: Did FAIL load ad >> provider id %s", providerName));
        Action action = Action.NONE;
        if (this.adLoadListener != null && (action = this.adLoadListener.onFailLoadAd(error, providerName)) == null) {
            action = Action.NONE;
        }
        switch (action) {
            case RETRY_SAME_PROVIDER: {
                AdsATALog.i("#AdCelNative: Trying SAME one");
                break;
            }
            case TRY_NEXT_PROVIDER: {
                AdsATALog.i("#AdCelNative: Trying NEXT one");
                break;
            }
            default: {
                AdsATALog.i(String.format("#AdCelNative: STOPED loading by Delegate >> %s", this.adLoadListener));
                this.onCompletion();
            }
        }
        return action;
    }

    private void notifyFailLoadAdAllProviders() {
        AdsATALog.i("#AdCelNative: All Providers did FAIL load ad");
        if (this.adLoadListener != null) {
            new Handler(this.context.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    AdCelNative.this.adLoadListener.onFailLoadAdAllProviders();
                }
            });
        }
    }

    private void sendLog(SdkLog sdkLog) {
        LogService logService = DefaultDependenciesFactory.logService();
        if (logService == null) {
            return;
        }
        logService.send(sdkLog);
    }

    public static interface AdLoadListener {
        public void onLoadAd(List<NativeAd> var1, String var2);

        public Action onFailLoadAd(String var1, String var2);

        public void onFailLoadAdAllProviders();

        public boolean onShouldSkipRTBProviders();
    }

    public static enum Action {
        NONE,
        RETRY_SAME_PROVIDER,
        TRY_NEXT_PROVIDER;

    }
}

