/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.nativeads;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import co.adcel.http.HttpClient;
import co.adcel.http.Request;
import co.adcel.http.SimpleHttpClient;
import co.adcel.logger.AdsATALog;
import co.adcel.nativeads.NativeAdView;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class NativeAd {
    protected Context context;
    protected Date timeStamp;
    private Date expiredDate;
    private ScheduledFuture expiredFuture;
    private OnAdExpiredListener onAdExpiredListener;
    private OnAdClickListener onAdClickListener;
    private HttpClient httpClient;

    public NativeAd(Context context) {
        this.context = context;
        this.timeStamp = Calendar.getInstance().getTime();
    }

    public abstract String getTitle();

    public abstract String getDescriptionText();

    public abstract String getIconUrl();

    public abstract float getIconWidth();

    public abstract float getIconHeight();

    public abstract String getImageUrl();

    public abstract float getImageWidth();

    public abstract float getImageHeight();

    public abstract String getCtaText();

    abstract String getClickUrl();

    abstract String getImpressionTrackingUrl();

    public abstract float getStarRaiting();

    public boolean isVideo() {
        return false;
    }

    Date getTimeStamp() {
        return this.timeStamp;
    }

    void trackImpression() {
        if (this.getImpressionTrackingUrl() == null) {
            return;
        }
        if (this.httpClient == null) {
            this.httpClient = new SimpleHttpClient();
        }
        this.httpClient.executeAsync(new Request.Builder(this.getImpressionTrackingUrl()).build());
    }

    void attachToView(NativeAdView nativeAdView) {
    }

    void detachFromView() {
    }

    void displayAndHandleClick(Context context) {
        this.openInExternalBrowser(context);
        if (this.onAdClickListener != null) {
            this.onAdClickListener.onAdClick();
        }
    }

    protected void openInExternalBrowser(Context context) {
        if (this.getClickUrl() != null) {
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.getClickUrl()));
            browserIntent.addFlags(0x10000000);
            context.startActivity(browserIntent);
        } else {
            AdsATALog.i("#AdCelNative: Can't display ad. Click URL is empty");
        }
    }

    public boolean isExpired() {
        return this.expiredDate != null && this.expiredDate.before(new Date());
    }

    protected void setExpiredDate(Date date) {
        if (this.expiredDate == null || !this.expiredDate.equals(date)) {
            this.expiredDate = date;
            if (this.expiredFuture != null) {
                this.expiredFuture.cancel(false);
                this.expiredFuture = null;
            }
            final NativeAd self = this;
            long time = (this.expiredDate.getTime() - new Date().getTime()) / 1000L;
            int seconds = Math.round(time);
            ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
            this.expiredFuture = worker.schedule(new Runnable(){

                @Override
                public void run() {
                    if (NativeAd.this.onAdExpiredListener != null) {
                        new Handler(NativeAd.this.context.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                NativeAd.this.onAdExpiredListener.onAdExpired(self);
                            }
                        });
                    }
                }
            }, (long)seconds, TimeUnit.SECONDS);
        }
    }

    public void setOnAdExpiredListener(OnAdExpiredListener onAdExpiredListener) {
        this.onAdExpiredListener = onAdExpiredListener;
    }

    void setOnAdClickListener(OnAdClickListener onAdClickListener) {
        this.onAdClickListener = onAdClickListener;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("\n");
        sb.append("Title:                 ").append(this.getTitle()).append("\n");
        sb.append("DescriptionText:       ").append(this.getDescriptionText()).append("\n");
        sb.append("IconUrl:               ").append(this.getIconUrl()).append("\n");
        sb.append("IconWidth:             ").append(this.getIconWidth()).append("\n");
        sb.append("IconHeight:            ").append(this.getIconHeight()).append("\n");
        sb.append("ImageUrl:              ").append(this.getImageUrl()).append("\n");
        sb.append("ImageWidth:            ").append(this.getImageWidth()).append("\n");
        sb.append("ImageHeight:           ").append(this.getImageHeight()).append("\n");
        sb.append("CtaText:               ").append(this.getCtaText()).append("\n");
        sb.append("ClickUrl:              ").append(this.getClickUrl()).append("\n");
        sb.append("ImpressionTrackingUrl: ").append(this.getImpressionTrackingUrl()).append("\n");
        sb.append("StarRaiting:           ").append(this.getStarRaiting()).append("\n");
        sb.append("TimeStamp:             ").append(this.getTimeStamp()).append("\n");
        return sb.toString();
    }

    public static interface OnAdClickListener {
        public void onAdClick();
    }

    public static interface OnAdExpiredListener {
        public void onAdExpired(NativeAd var1);
    }
}

