/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.nativeads;

import android.content.Context;
import co.adcel.common.AdProviderDTO;
import co.adcel.nativeads.NativeAd;
import co.adcel.nativeads.NativeAdsManager;
import java.util.ArrayList;
import java.util.List;

public abstract class NativeAdProvider
implements NativeAd.OnAdClickListener {
    protected Context context;
    protected int providerId;
    protected AdProviderDTO provider;
    protected NativeAdsManager nativeAdsManager;
    protected OnAdLoadListener onAdLoadListener;
    protected OnAdClickListener onAdClickListener;

    public NativeAdProvider(Context context, Integer providerId, AdProviderDTO provider, NativeAdsManager nativeAdsManager, OnAdLoadListener onAdLoadListener) {
        this.context = context;
        this.providerId = providerId;
        this.provider = provider;
        this.nativeAdsManager = nativeAdsManager;
        this.onAdLoadListener = onAdLoadListener;
    }

    public int getProviderId() {
        return this.providerId;
    }

    public int getRtbProviderId() {
        return 0;
    }

    public abstract void loadAd(int var1);

    public boolean isRTB() {
        return false;
    }

    List<NativeAd> getAds(NativeAd ad) {
        ArrayList<NativeAd> ads = new ArrayList<NativeAd>();
        ads.add(ad);
        return ads;
    }

    @Override
    public void onAdClick() {
        if (this.onAdClickListener != null) {
            this.onAdClickListener.onAdClick(this);
        }
    }

    void adLoadSuccess(List<NativeAd> nativeAds) {
        for (NativeAd ad : nativeAds) {
            ad.setOnAdClickListener(this);
        }
        this.onAdLoadListener.onLoadAdSuccess(nativeAds, this);
    }

    int getMinAndroidApiVer() {
        return 14;
    }

    public void setOnAdClickListener(OnAdClickListener onAdClickListener) {
        this.onAdClickListener = onAdClickListener;
    }

    public static interface OnAdClickListener {
        public void onAdClick(NativeAdProvider var1);
    }

    public static interface OnAdLoadListener {
        public void onLoadAdSuccess(List<NativeAd> var1, NativeAdProvider var2);

        public void onLoadAdFailed(String var1, NativeAdProvider var2);
    }
}

