/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.nativeads;

import android.content.Context;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.common.AdProviderDTO;
import co.adcel.logger.AdsATALog;
import co.adcel.nativeads.NativeAdProvider;
import co.adcel.nativeads.NativeAdsManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class NativeAdProviderSelectorBase {
    private Map<Integer, String> providerMap = new HashMap<Integer, String>();

    NativeAdProviderSelectorBase() {
        this.providerMap.put(8, "co.adcel.nativeads.ApplovinNativeAdProvider");
        this.providerMap.put(21, "co.adcel.nativeads.MyTargetNativeAdProvider");
        this.providerMap.put(3, "co.adcel.nativeads.SmaatoNativeAdProvider");
        this.providerMap.put(26, "co.adcel.nativeads.YandexNativeAdProvider");
        this.providerMap.put(7, "co.adcel.nativeads.AdMobNativeAdProvider");
        this.providerMap.put(5, "co.adcel.nativeads.StartAppNativeAdProvider");
        this.providerMap.put(31, "co.adcel.nativeads.FacebookNativeAdProvider");
        this.providerMap.put(18, "co.adcel.nativeads.MoPubNativeAdProvider");
        this.providerMap.put(6, "co.adcel.nativeads.InMobiNativeAdProvider");
    }

    protected NativeAdProvider create(Context context, int providerId, AdProviderDTO provider, NativeAdsManager nativeAdsManager, NativeAdProvider.OnAdLoadListener onAdLoadListener) {
        MediationContext aContext = nativeAdsManager.getMediationContext();
        String providerName = provider.getProviderName();
        String className = this.providerMap.get(providerId);
        if (className != null && !aContext.isProviderDisabled("native", providerName)) {
            try {
                Class<?> clazz = Class.forName(className);
                Method m = clazz.getDeclaredMethod("isProviderInstalled", new Class[0]);
                m.setAccessible(true);
                boolean installed = (Boolean)m.invoke(null, new Object[0]);
                if (installed) {
                    AdsATALog.i("==== Native Provider " + provider.getProviderName() + " is installed");
                    NativeAdProvider nativeAdProvider = (NativeAdProvider)clazz.getDeclaredConstructor(Context.class, Integer.class, AdProviderDTO.class, NativeAdsManager.class, NativeAdProvider.OnAdLoadListener.class).newInstance(context, providerId, provider, nativeAdsManager, onAdLoadListener);
                    return nativeAdProvider;
                }
                AdsATALog.i("==== Native Provider " + provider.getProviderName() + " is not installed");
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                AdsATALog.i("==== Native Provider " + provider.getProviderName() + " is not installed");
            }
            catch (Throwable e) {
                AdsATALog.e("==== Native Provider " + provider.getProviderName() + " instantiate error: " + e.getMessage());
            }
            return null;
        }
        return null;
    }
}

