/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.nativeads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import co.adcel.nativeads.MediaLayout;
import co.adcel.nativeads.NativeAd;

public class NativeAdView
extends FrameLayout {
    private NativeAd nativeAd;
    private View titleView;
    private View descriptionTextView;
    private View iconView;
    private MediaLayout mediaLayout;
    private View ctaTextView;
    private View starRatingView;
    private OnAdClickListener onAdClickListener;

    public NativeAdView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public NativeAdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public NativeAdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
    }

    public void setOnAdClickListener(OnAdClickListener onAdClickListener) {
        this.onAdClickListener = onAdClickListener;
    }

    public void setNativeAd(NativeAd nativeAd) {
        if (this.nativeAd != null) {
            this.nativeAd.detachFromView();
            this.nativeAd = null;
        }
        this.nativeAd = nativeAd;
        this.nativeAd.trackImpression();
        this.nativeAd.attachToView(this);
    }

    public NativeAd getNativeAd() {
        return this.nativeAd;
    }

    public void setTitleView(View titleView) {
        this.titleView = titleView;
    }

    public View getTitleView() {
        return this.titleView;
    }

    public void setDescriptionTextView(View descriptionTextView) {
        this.descriptionTextView = descriptionTextView;
    }

    public View getDescriptionTextView() {
        return this.descriptionTextView;
    }

    public void setIconView(View iconView) {
        this.iconView = iconView;
    }

    public View getIconView() {
        return this.iconView;
    }

    @Deprecated
    public void setImageView(View imageView) {
        throw new IllegalStateException("co.adcel.nativeads.NativeAdView.setImageView is deprecated. Use setMediaLayout instead");
    }

    public void setMediaLayout(MediaLayout mediaLayout) {
        this.mediaLayout = mediaLayout;
    }

    public MediaLayout getMediaLayout() {
        return this.mediaLayout;
    }

    public void setCtaTextView(View ctaTextView) {
        this.ctaTextView = ctaTextView;
        if (this.ctaTextView == null) {
            return;
        }
        this.ctaTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NativeAdView.this.adClick();
            }
        });
        this.setClickable(true);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 0) {
                    NativeAdView.this.adClick();
                }
                return false;
            }
        });
    }

    public View getCtaTextView() {
        return this.ctaTextView;
    }

    public void setStarRaitingView(View starRatingView) {
        this.starRatingView = starRatingView;
    }

    public View getStarRaitingView() {
        return this.starRatingView;
    }

    void adClick() {
        if (this.nativeAd != null) {
            this.nativeAd.displayAndHandleClick(this.ctaTextView.getContext());
        }
        if (this.onAdClickListener != null) {
            this.onAdClickListener.onAdClick(this);
        }
    }

    public static interface OnAdClickListener {
        public void onAdClick(NativeAdView var1);
    }
}

