/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.nativeads;

import android.content.Context;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.common.AdProviderDTO;
import co.adcel.nativeads.AdCelNative;
import co.adcel.nativeads.NativeAdProvider;
import co.adcel.nativeads.NativeAdProviderSelectorBase;
import java.util.List;

public class NativeAdsManager {
    private MediationContext mediationContext;
    private List<String> providerQueue;
    private NativeAdProviderSelectorBase providerSelector;

    public void notifyNativeLoad() {
        if (this.mediationContext.getOnNativeAdsAvailabilityListener() != null) {
            this.mediationContext.getOnNativeAdsAvailabilityListener().onAvailable();
        }
    }

    public void notifyNativeLoadFail(String error) {
        if (this.mediationContext.getOnNativeAdsAvailabilityListener() != null) {
            this.mediationContext.getOnNativeAdsAvailabilityListener().onError(error);
        }
    }

    public NativeAdsManager(MediationContext mediationContext) {
        if (mediationContext == null) {
            throw new IllegalArgumentException("MediationContext can't be null");
        }
        this.mediationContext = mediationContext;
    }

    public MediationContext getMediationContext() {
        return this.mediationContext;
    }

    public void createProviderPriorityList() {
        NativeAdProviderSelectorBase providerSelector = new NativeAdProviderSelectorBase();
        this.providerQueue = this.mediationContext.getProvidersQueues().get("native");
        this.providerSelector = providerSelector;
    }

    public boolean isInitialized() {
        return this.getProviderQueue() != null;
    }

    public void loadAd(Context context, int count, boolean random, boolean async, AdCelNative.AdLoadListener adLoadListener) {
        AdCelNative.loadAd(this, context, count, random, async, adLoadListener);
    }

    protected List<String> getProviderQueue() {
        return this.providerQueue;
    }

    protected NativeAdProvider getProvider(Context context, AdProviderDTO provider, NativeAdProvider.OnAdLoadListener onAdLoadListener) {
        return this.providerSelector.create(context, Integer.parseInt(provider.getProviderId()), provider, this, onAdLoadListener);
    }
}

