package com.amity.socialcloud.sdk.push;

import androidx.annotation.NonNull;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.schedulers.Schedulers;

public class AmityFcm implements PushService {

    private AmityFcm() {
    }

    /**
     * comment
     */
    // TODO: 2019-07-05 checking null
    @Override
    public Completable setup(@NonNull String fcmToken) {
        if (!PushInitProvider.isInitialized()) {
            return Completable.never();
        }
        return EkoPushContractWrapper.Companion.getInstance()
            .flatMapCompletable(wrapper ->
                wrapper
                    .getPushContract()
                    .insertFcmToken(fcmToken)
            )
            .doOnError(throwable -> { })
            .subscribeOn(Schedulers.io());
    }

    public static AmityFcm create() {
        return new AmityFcm();
    }
}
