package com.amity.socialcloud.sdk.chat.data.channel

import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.AmityCoreClient
import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.chat.channel.AmityChannelSortOption
import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra
import com.ekoapp.ekosdk.internal.EkoChannelEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

internal class ChannelLocalDataStore {

    fun saveChannels(
        channels: List<EkoChannelEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().channelDao().save(channels)
        }
    }

    fun getChannel(channelId: String): EkoChannelEntity? {
        return UserDatabase.get().channelDao().getByIdNow(channelId)
    }

    fun observeChannel(channelId: String): Flowable<EkoChannelEntity> {
        return UserDatabase.get().channelDao().getChannel(channelId)
    }

    fun getAllJoinedChannels(): Flowable<List<EkoChannelWithMembershipAndExtra>> {
        return UserDatabase.get().channelDao()
            .getAllJoinedChannels(SessionLocalDataStore().getActiveUserId())
    }

    fun getChannelPagingSource(
        types: Set<AmityChannel.Type>,
        filter: AmityChannelFilter,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        isDeleted: Boolean?,
    ): PagingSource<Int, EkoChannelEntity> {
        return UserDatabase.get().channelPagingDao().getChannelPagingSource(
            types,
            filter,
            includingTags,
            excludingTags,
            isDeleted
        )
    }

    fun getLatestChannel(
        types: Set<AmityChannel.Type>,
        filter: AmityChannelFilter,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        isDeleted: Boolean?,
        dynamicQueryStreamKeyCreator: DynamicQueryStreamKeyCreator,
        nonce: Int
    ): Flowable<EkoChannelEntity> {
        return UserDatabase.get().channelDao().getLatestChannel(
            ChannelHelper.getChannelTypes(types).toTypedArray(),
            SessionLocalDataStore().getActiveUserId(),
            filter.memberships.toTypedArray(),
            includingTags.toTypedArray(),
            excludingTags.toTypedArray(),
            isDeleted,
            dynamicQueryStreamKeyCreator.toMap().hashCode(),
            nonce,
            DateTime.now()
        )
    }

}