package com.amity.socialcloud.sdk.chat.data.channel

import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.common.ModelMapper
import com.ekoapp.ekosdk.internal.EkoChannelEntity


internal class ChannelModelMapper : ModelMapper<EkoChannelEntity, AmityChannel>() {

    override fun map(entity: EkoChannelEntity): AmityChannel {
        return entity.run {
            AmityChannel(
                channelId = channelId,
                displayName = displayName,
                tags = tags,
                metadata = metadata,
                messageCount = messageCount,
                memberCount = memberCount,
                moderatorMemberCount = moderatorMemberCount,
                type = AmityChannel.Type.enumOf(channelType),
                avatarFileId = avatarFileId,
                isRateLimited = isRateLimited,
                isMuted =  isMuted,
                isDeleted = isDeleted,
                lastActivity = lastActivity,
                createdAt = createdAt,
                updatedAt = updatedAt
            )
        }
    }

}