package com.amity.socialcloud.sdk.chat.data.channel

import com.amity.socialcloud.sdk.chat.channel.AmityChannelCreator
import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.infra.retrofit.request.QueryOptionsRequestParams
import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.ChannelQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelUpdateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CreateChannelRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CreateConversationWithUserIdsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class ChannelRemoteDataStore {

    fun createChannel(
        channelId: String? = null,
        creationType: AmityChannelCreator.CreationType,
        displayName: String? = null,
        avatarFileId: String? = null,
        metadata: JsonObject? = null,
        tags: AmityTags? = null,
        userIds: List<String>? = null
    ): Single<ChannelQueryDto> {
        return EkoApi.get(ChannelApi::class)
            .flatMap {
                it.createChannel(
                    CreateChannelRequest(
                        channelId = channelId,
                        type = creationType.apiKey,
                        displayName = displayName,
                        tags = tags?.takeIf { it.isNotEmpty() },
                        metadata = metadata,
                        avatarFileId = avatarFileId,
                        userIds = userIds?.takeIf { it.isNotEmpty() }
                    )
                )
            }
    }


    fun createConversationChannel(
        displayName: String? = null,
        avatarFileId: String? = null,
        metadata: JsonObject? = null,
        tags: AmityTags? = null,
        userIds: List<String>? = null
    ): Single<ChannelQueryDto> {
        return EkoApi.get(ChannelApi::class)
            .flatMap {
                it.createConversationChannel(
                    CreateConversationWithUserIdsRequest(
                        displayName = displayName,
                        avatarFileId = avatarFileId,
                        userIds = userIds?.takeIf { it.isNotEmpty() },
                        tags = tags?.takeIf { it.isNotEmpty() },
                        metadata = metadata,
                        isDistinct = true
                    )
                )
            }
    }

    fun updateChannel(
        channelId: String,
        displayName: String? = null,
        avatarFileId: String? = null,
        metadata: JsonObject? = null,
        tags: AmityTags? = null,
    ): Single<ChannelQueryDto> {
        return EkoApi.get(ChannelApi::class)
            .flatMap {
                it.updateChannel(
                    channelId,
                    ChannelUpdateRequest(
                        channelId = channelId,
                        displayName = displayName,
                        avatarFileId = avatarFileId,
                        metadata = metadata,
                        tags = tags
                    )
                )
            }
    }

    fun getChannel(channelId: String): Single<ChannelQueryDto> {
        return EkoApi.get(ChannelApi::class)
            .flatMap {
                it.getChannel(channelId)
            }
    }

    fun joinChannel(channelId: String): Single<ChannelQueryDto> {
        return EkoApi.get(ChannelApi::class)
            .flatMap {
                it.joinChannel(channelId)
            }
    }

    fun leaveChannel(channelId: String): Single<ChannelQueryDto> {
        return EkoApi.get(ChannelApi::class)
            .flatMap {
                it.leaveChannel(channelId)
            }
    }

    fun queryChannels(
        types: List<String>? = null,
        filter: String? = null,
        includingTags: List<String>? = null,
        excludingTags: List<String>? = null,
        isDeleted: Boolean? = null,
        sortBy: String? = null,
        options: QueryOptionsRequestParams
    ): Single<ChannelQueryDto> {
        return EkoApi.get(ChannelApi::class)
            .flatMap {
                it.queryChannels(
                    types = types?.takeIf { it.isNotEmpty() },
                    filter = filter,
                    tags = includingTags?.takeIf { it.isNotEmpty() },
                    excludeTags = excludingTags?.takeIf { it.isNotEmpty() },
                    isDeleted = isDeleted,
                    sortBy = sortBy,
                    limit = options.limit,
                    token = options.token
                )
            }
    }

}