package com.amity.socialcloud.sdk.chat.data.channel.membership

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelMembershipDto
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity


class ChannelMembershipEntityMapper : EntityMapper<EkoChannelMembershipDto, ChannelMembershipEntity>() {

    override fun map(list: List<EkoChannelMembershipDto>): List<ChannelMembershipEntity> {
        return list.map { map(it) }
    }

    fun map(dto: EkoChannelMembershipDto) : ChannelMembershipEntity {
        return ChannelMembershipEntity.create(dto.channelId, dto.userId).apply {
            membership = dto.membership ?: "none"
            isBanned = dto.isBanned ?: false
            isMuted = dto.isMuted ?: false
            readToSegment = dto.readToSegment ?: 0
            lastMentionedSegment = dto.lastMentionedSegment ?: 0
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
            roles = dto.roles
            permissions = dto.permissions
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
        }
    }

}