package com.amity.socialcloud.sdk.chat.data.channel.membership.paging

import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.amity.socialcloud.sdk.core.user.AmityMembershipType
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import com.ekoapp.ekosdk.internal.keycreator.toSqlArray


internal class ChannelMemberSearchKeyCreator(
    private val channelId: String,
    private val keyword: String,
    private val roles: AmityRoles,
    private val memberships: List<AmityMembershipType>,
    private val isMuted: Boolean?,
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "channelId" to channelId,
            "keyword" to keyword,
            "roles" to roles,
            "memberships" to memberships,
            "isMuted" to (isMuted?.toString() ?: "null"),
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(channelId, roles, memberships, isMuted)
    }

    private fun getConditionStatement(
        channelId: String,
        roles: AmityRoles,
        memberships: List<AmityMembershipType>,
        isMuted: Boolean?,
    ): String {
        val membershipFilter = (memberships.takeIf { it.isNotEmpty() } ?: listOf(AmityMembershipType.MEMBER, AmityMembershipType.BANNED)).map { it.apiKey }.toSqlArray()
        val membershipFilterStatement =
            "(channel_membership.membership IN (${membershipFilter})"

        val isMutedFilter = when {
            isMuted == null -> " and channel_membership.isMuted = 0)"
            isMuted && memberships.isNotEmpty() -> " or channel_membership.isMuted = 1)"
            isMuted && memberships.isEmpty() -> " and channel_membership.isMuted = 1)"
            else -> "  and channel_membership.isMuted = 0)"
        }

        val roleFilter = if (roles.get().isEmpty()) ""
        else " and channel_membership.userId IN (SELECT userId from channel_role  where channelId = '${channelId}' and roleName IN (${roles.get().toSqlArray()}))"

        return membershipFilterStatement +
                isMutedFilter +
                roleFilter
    }

}