package com.amity.socialcloud.sdk.chat.data.channel.membership.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.amity.socialcloud.sdk.core.user.AmityMembershipType
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface ChannelMemberSearchPagingDao : DynamicQueryStreamPagingDao<ChannelMembershipEntity> {

    @RawQuery(observedEntities = [ChannelMembershipEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, ChannelMembershipEntity>

    fun getChannelMembershipPagingSource(
        channelId: String,
        keyword: String,
        memberships: List<AmityMembershipType>,
        isMuted: Boolean?,
        roles: AmityRoles,
    ): PagingSource<Int, ChannelMembershipEntity> {
        val query = generateQueryStreamSQL(
                tableName = "channel_membership",
                primaryKeyColumnName = "userId",
                additionalPrimaryKeys = mapOf("channelId" to channelId),
                nonce = AmityNonce.CHANNEL_MEMBERSHIP_SEARCH,
                order = AmityPagingDao.Order.ASC,
                dynamicQueryStreamKeyCreator = ChannelMemberSearchKeyCreator(
                    channelId = channelId,
                    keyword = keyword,
                    memberships = memberships,
                    isMuted = isMuted,
                    roles = roles
                )
            )

        return queryPagingData(query)
    }

}
