package com.amity.socialcloud.sdk.chat.data.channel.paging

import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.chat.data.channel.ChannelHelper
import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import com.ekoapp.ekosdk.internal.keycreator.toSqlArray

internal class ChannelKeyCreator(
    private val types: Set<AmityChannel.Type>,
    private val filter: AmityChannelFilter,
    private val includingTags: AmityTags,
    private val excludingTags: AmityTags,
    private val isDeleted: Boolean?,
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "types" to types,
            "filter" to filter.apiKey,
            "includingTags" to includingTags,
            "excludingTags" to excludingTags,
            "isDeleted" to (isDeleted?.toString() ?: "null"),
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(types, filter, includingTags, excludingTags, isDeleted)
    }

    private fun getConditionStatement(
        types: Set<AmityChannel.Type>,
        filter: AmityChannelFilter,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        isDeleted: Boolean?,
    ): String {
        //channel type filter
        val channelTypeFilterStatement =
            "channel.channelType IN (${ChannelHelper.getChannelTypes(types).toSqlArray()})"

        //membership filter
        val userId = SessionLocalDataStore().getActiveUserId()
        val memebershipFilterStatement = if (filter == AmityChannelFilter.ALL) "" else
            " and channel.channelId IN (SELECT channelId from channel_membership where membership IN (${filter.memberships.toSqlArray()}) and userId = '${userId}')"

        //including tags filter
        val includingTagsFilterStatement = if (includingTags.isEmpty()) "" else
            " and channel.channelId IN (SELECT channelId from channel_tag where tagName IN (${includingTags.toSqlArray()}))"

        //excluding tags filter
        val excludingTagsFilterStatement = if (excludingTags.isEmpty()) "" else
            " and channel.channelId not IN (SELECT channelId from channel_tag where tagName IN (${excludingTags.toSqlArray()}))"

        //isDeleted filter
        val isDeletedFilterStatement = when (isDeleted) {
            null -> {
                ""
            }
            true -> {
                " and channel.isDeleted = 1"
            }
            false -> {
                " and channel.isDeleted = 0"
            }
        }

        return channelTypeFilterStatement +
                memebershipFilterStatement +
                includingTagsFilterStatement +
                excludingTagsFilterStatement +
                isDeletedFilterStatement
    }

}