package com.amity.socialcloud.sdk.chat.data.channel.reader

import com.ekoapp.ekosdk.EkoChannelExtra
import com.ekoapp.ekosdk.EkoChannelReadStatus
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

internal class ChannelReaderLocalDataStore {

    fun startReading(channelId: String): Completable {
        return Completable.fromAction {
            val database = UserDatabase.get()
            val channelDao = database.channelDao()
            val readToSegment = channelDao.getByIdNow(channelId)?.messageCount ?: 0
            val channelExtraDao = database.channelExtraDao()
            channelExtraDao.updateLocalReadToSegment(channelId, readToSegment)
            channelExtraDao.updateReadStatus(channelId, EkoChannelReadStatus.READING)
            channelDao.updateUnreadCount(channelId)
        }
    }

    fun stopReading(channelId: String): Completable {
        return Completable.fromAction {
            UserDatabase.get().channelExtraDao()
                .updateReadStatus(channelId, EkoChannelReadStatus.NOT_READING)
        }
    }

    fun observeChannelReader(channelId: String): Flowable<EkoChannelExtra> {
        return UserDatabase.get().channelExtraDao().getById(channelId)
    }

    fun getChannelReader(channelId: String): EkoChannelExtra? {
        return UserDatabase.get().channelExtraDao().getByIdNow(channelId)
    }

}