package com.amity.socialcloud.sdk.chat.data.channel.reader

import com.ekoapp.core.utils.toV3
import com.ekoapp.ekosdk.internal.api.EkoSocket
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelStartReadingRequest
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelStopReadingRequest
import io.reactivex.rxjava3.core.Completable

internal class ChannelReaderRemoteDataStore {

    fun stopReading(channelId: String) : Completable {
        return EkoSocket.rpc(ChannelStopReadingRequest(channelId)).ignoreElement().toV3()
    }

    fun startReading(channelId: String) : Completable {
        return EkoSocket.rpc(ChannelStartReadingRequest(channelId)).ignoreElement().toV3()
    }

}