package com.amity.socialcloud.sdk.chat.data.message

import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.CreateMessageRequest
import com.ekoapp.ekosdk.internal.api.socket.request.MessageUpdateDataRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface MessageApi {

    @GET("api/v3/messages/{messageId}")
    fun getMessage(
        @Path("messageId") messageId: String,
    ): Single<MessageQueryDto>

    @POST("api/v3/messages")
    fun createMessage(
        @Body request: CreateMessageRequest
    ): Single<MessageQueryDto>

    @PUT("api/v3/messages/{messageId}")
    fun updateMessage(
        @Path("messageId") messageId: String,
        @Body request: MessageUpdateDataRequest
    ): Single<MessageQueryDto>

    @DELETE("api/v3/messages/{messageId}")
    fun deleteMessage(
        @Path("messageId") messageId: String
    ): Single<EkoDeletionDto>

    @GET("api/v3/messages")
    fun queryMessages(
        @Query("channelId") channelId: String? = null,
        @Query("filterByParentId") filterByParentId: Boolean? = null,
        @Query("parentId") parentId: String? = null,
        @Query("isDeleted") isDeleted: Boolean? = null,
        @Query("tags[]") tags: List<String>? = null,
        @Query("excludeTags[]") excludeTags: List<String>? = null,
        @Query("type", encoded = true) dataType: String? = null,
        @Query("options[skip]", encoded = true) skip: Int? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[first]", encoded = true) first: Int? = null,
        @Query("options[last]", encoded = true) last: Int? = null,
        @Query("options[type]", encoded = true) type: String? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<MessageQueryDto>

    @POST("api/v3/messages/{messageId}/flag")
    fun flagMessage(
        @Path("messageId") messageId: String
    ): Single<MessageQueryDto>

    @DELETE("api/v3/messages/{messageId}/unflag")
    fun unflagMessage(
        @Path("messageId") messageId: String
    ): Single<MessageQueryDto>

    @GET("api/v3/messages/{messageId}/isFlaggedByMe")
    fun isFlaggedByMe(
        @Path("messageId") messageId: String
    ): Single<JsonObject>

}