package com.amity.socialcloud.sdk.chat.data.message

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.EkoMessageEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap

internal class MessageEntityMapper : EntityMapper<EkoMessageDto, EkoMessageEntity>() {

    override fun map(list: List<EkoMessageDto>): List<EkoMessageEntity> {
        return list.map { map(it) }
    }

    fun map(dto: EkoMessageDto): EkoMessageEntity {
        return EkoMessageEntity().apply {
            messageId = dto.getMessageId()
            channelId = dto.getChannelId()
            userId = dto.getUserId()
            parentId = dto.getParentId()
            fileId = dto.getFileId()
            type = dto.getType()
            setChannelSegment(dto.getChannelSegment())
            childrenNumber = dto.getChildrenNumber()
            data = dto.getData()
            isDeleted = dto.isDeleted()
            readByCount = dto.getReadByCount()
            flagCount = dto.getFlagCount()
            tags = dto.getTags()
            reactionCount = dto.getReactionCount()
            reactions = if (dto.getReactions() == null) AmityReactionMap() else dto.getReactions()
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
            editedAt = dto.getEditedAt()
            metadata = dto.getMetadata()
            if (dto.getMentionees() != null) {
                mentionees = dto.getMentionees()
            }
        }
    }

}