package com.amity.socialcloud.sdk.chat.data.message

import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagEntityMapper
import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagLocalDataStore
import com.amity.socialcloud.sdk.chat.data.message.reaction.MessageReactionEntityMapper
import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import io.reactivex.rxjava3.core.Completable

internal class MessageEventPersister : QueryPersister<MessageQueryDto>() {

    override fun persist(dto: MessageQueryDto): Completable {

        val message = dto.messages?.first()
        val reactor = message?.latestReaction
        val user = dto.users.find { it.userId == reactor?.userId }
        val reactorPersistenceCompletable : Completable = if (reactor == null) {
            Completable.complete()
        } else {
            when(reactor.eventName) {
                "add" ->  ReactionLocalDataStore().addReaction(
                    reactionId = reactor.reactionId,
                    referenceType = ReactionReferenceType.MESSAGE,
                    referenceId = message.messageId,
                    reactionName = reactor.reactionName,
                    userId = reactor.userId,
                    userDisplayName = user?.displayName,
                    createdAt = reactor.createdAt,
                    updateAt = reactor.updatedAt
                )
                "remove" -> ReactionLocalDataStore().removeReaction(
                    ReactionReferenceType.MESSAGE,
                    message.messageId,
                    reactor.reactionName,
                    reactor.userId
                )
                else -> Completable.complete()
            }
        }
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users)))
            .andThen(MessageLocalDataStore().saveMessages(MessageEntityMapper().map(dto.messages)))
            .andThen(MessageFlagLocalDataStore().saveFlags(MessageFlagEntityMapper().map(dto.messages)))
            .andThen(ReactionLocalDataStore().saveReactionsAndDeletePrevious(ReactionReferenceType.MESSAGE, dto.messages.map { it.messageId }, MessageReactionEntityMapper().map(dto.messages)))
            .andThen(reactorPersistenceCompletable)
    }

}