package com.amity.socialcloud.sdk.chat.data.message

import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.core.data.mention.LegacyMentioneeModelMapper
import com.ekoapp.ekosdk.internal.EkoMessageEntity


internal class MessageModelMapper : ModelMapper<EkoMessageEntity, AmityMessage>() {

    override fun map(entity: EkoMessageEntity): AmityMessage {
        return entity.run {
            AmityMessage(
                messageId = messageId,
                channelId = channelId,
                userId = userId,
                parentId = parentId,
                channelSegment = getChannelSegment(),
                childrenNumber = childrenNumber,
                editedAt = editedAt,
                isDeleted = isDeleted,
                readByCount = readByCount,
                flagCount = flagCount,
                tags = tags,
                fileId = fileId,
                reactions = reactions,
                reactionCount = reactionCount,
                type = getDataType(),
                data = data,
                syncState = syncState,
                createdAt = createdAt,
                updatedAt = updatedAt,
                metadata = metadata,
                mentionees = LegacyMentioneeModelMapper().map(entity.mentionees)
            )
        }
    }

}