package com.amity.socialcloud.sdk.chat.data.message


import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagEntityMapper
import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagLocalDataStore
import com.amity.socialcloud.sdk.chat.data.message.reaction.MessageReactionEntityMapper
import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import io.reactivex.rxjava3.core.Completable


internal class MessageQueryPersister : QueryPersister<MessageQueryDto>() {

    override fun persist(dto: MessageQueryDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users)))
            .andThen(MessageLocalDataStore().saveMessages(MessageEntityMapper().map(dto.messages)))
            .andThen(MessageFlagLocalDataStore().saveFlags(MessageFlagEntityMapper().map(dto.messages)))
            .andThen(ReactionLocalDataStore().saveReactionsAndDeletePrevious(ReactionReferenceType.MESSAGE, dto.messages.map { it.messageId }, MessageReactionEntityMapper().map(dto.messages)))
    }

}