package com.amity.socialcloud.sdk.chat.data.message

import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.CreateMessageRequest
import com.ekoapp.ekosdk.internal.api.socket.request.MessageUpdateDataRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class MessageRemoteDataStore {

    fun createMessage(
        messageId: String,
        parentId: String?,
        channelId: String,
        fileId: String?,
        type: String,
        data: JsonObject,
        tags: AmityTags,
        metadata: JsonObject?,
        mentionees: List<AmityMentioneeTarget>?
    ): Single<MessageQueryDto> {
        val request = CreateMessageRequest(
            messageId,
            channelId,
            parentId,
            fileId,
            type,
            data,
            tags,
            metadata,
            mentionees
        )
        return EkoApi.get(MessageApi::class)
            .flatMap {
                it.createMessage(request)
            }

    }

    fun updateMessage(
        messageId: String,
        data: JsonObject?,
        tags: AmityTags?,
        metadata: JsonObject?,
        mentionees: List<AmityMentioneeTarget>?
    ): Single<MessageQueryDto> {
        val request = MessageUpdateDataRequest(data, tags, metadata, mentionees)
        return EkoApi.get(MessageApi::class)
            .flatMap {
                it.updateMessage(messageId, request)
            }
    }

    fun deleteMessage(messageId: String): Completable {
        return EkoApi.get(MessageApi::class)
            .flatMapCompletable {
                it.deleteMessage(messageId).ignoreElement()
            }
    }

    fun getMessage(messageId: String): Single<MessageQueryDto> {
        return EkoApi.get(MessageApi::class)
            .flatMap {
                it.getMessage(messageId)
            }
    }

    fun queryMessages(
        channelId: String,
        filterByParentId: Boolean? = null,
        parentId: String? = null,
        isDeleted: Boolean? = null,
        includingTags: AmityTags? = null,
        excludingTags: AmityTags? = null,
        dataType: String? = null,
        skip: Int? = null,
        limit: Int? = null,
        first: Int? = null,
        last: Int? = null,
        type: String? = null,
        token: String? = null
    ): Single<MessageQueryDto> {
        return EkoApi.get(MessageApi::class)
            .flatMap {
                it.queryMessages(
                    channelId = channelId,
                    filterByParentId = filterByParentId,
                    parentId = parentId,
                    isDeleted = isDeleted,
                    tags = includingTags,
                    excludeTags = excludingTags,
                    dataType = dataType,
                    skip = skip,
                    limit = limit,
                    first = first,
                    last = last,
                    type = type,
                    token = token
                )
            }
    }

}