package com.amity.socialcloud.sdk.chat.data.message.flag

import com.amity.socialcloud.sdk.chat.data.message.MessageApi
import com.ekoapp.ekosdk.internal.api.EkoApi
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

class MessageFlagRemoteDataStore {

    fun flagMessage(messageId: String): Single<MessageQueryDto> {
        return EkoApi.get(MessageApi::class)
            .flatMap {
                it.flagMessage(messageId)
            }
    }

    fun unflagMessage(messageId: String): Single<MessageQueryDto> {
        return EkoApi.get(MessageApi::class)
            .flatMap {
                it.unflagMessage(messageId)
            }
    }

    fun isFlaggedByMe(messageId: String) : Single<JsonObject> {
        return EkoApi.get(MessageApi::class)
            .flatMap {
                it.isFlaggedByMe(messageId)
            }
    }

}