package com.amity.socialcloud.sdk.chat.data.message.paging

import com.amity.socialcloud.sdk.core.AmityTags
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import com.ekoapp.ekosdk.internal.keycreator.toSqlArray

internal class MessageKeyCreator(
    private val channelId: String,
    private val isFilterByParentId: Boolean,
    private val parentId: String?,
    private val includingTags: AmityTags,
    private val excludingTags: AmityTags,
    private val isDeleted: Boolean?,
    private val stackFromEnd: Boolean,
    private val type: String?
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "channelId" to channelId,
            "parentId" to (parentId ?: "null"),
            "isFilterByParentId" to isFilterByParentId,
            "includingTags" to includingTags,
            "excludingTags" to excludingTags,
            "isDeleted" to (isDeleted?.toString() ?: "null"),
            "stackFromEnd" to stackFromEnd,
            "type" to (type ?: "")
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            channelId = channelId,
            includingTags = includingTags,
            excludingTags = excludingTags,
            isDeleted = isDeleted,
            type = type
        )
    }

    private fun getConditionStatement(
        channelId: String,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        isDeleted: Boolean?,
        type: String?
    ): String {
        //channel filter
        val channelFilterStatement =
            "message.channelId = '$channelId'"

        //including tags filter
        val includingTagsFilterStatement = if (includingTags.isEmpty()) "" else
            " and message.messageId IN (SELECT messageId from message_tag where tagName IN (${includingTags.toSqlArray()}))"

        //excluding tags filter
        val excludingTagsFilterStatement = if (excludingTags.isEmpty()) "" else
            " and message.messageId not IN (SELECT messageId from message_tag where tagName IN (${excludingTags.toSqlArray()}))"

        //isDeleted filter
        val isDeletedFilterStatement = when (isDeleted) {
            null -> {
                ""
            }
            true -> {
                " and message.isDeleted = 1"
            }
            false -> {
                " and message.isDeleted = 0"
            }
        }
    
        //Type filter
        val typeFilterStatement = if (type == null || type.isEmpty()) "" else
            " and message.type == '$type'"

        return channelFilterStatement +
                includingTagsFilterStatement +
                excludingTagsFilterStatement +
                isDeletedFilterStatement +
                typeFilterStatement
    }

}