package com.amity.socialcloud.sdk.chat.data.message.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.core.AmityTags
import com.ekoapp.ekosdk.internal.EkoMessageEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao


@Dao
internal interface MessagePagingDao : DynamicQueryStreamPagingDao<EkoMessageEntity> {

    @RawQuery(observedEntities = [EkoMessageEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, EkoMessageEntity>

    fun getMessagePagingSource(
        channelId: String,
        isFilterByParentId: Boolean,
        parentId: String?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        isDeleted: Boolean?,
        stackFromEnd: Boolean,
        type: String?
    ): PagingSource<Int, EkoMessageEntity> {
        val order = AmityPagingDao.Order.DESC
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "message",
                primaryKeyColumnName = "messageId",
                nonce = AmityNonce.MESSAGE_LIST,
                sortColumn = "channelSegment",
                order = order,
                dynamicQueryStreamKeyCreator = MessageKeyCreator(
                    channelId = channelId,
                    parentId = parentId,
                    isFilterByParentId = isFilterByParentId,
                    includingTags = includingTags,
                    excludingTags = excludingTags,
                    isDeleted = isDeleted,
                    stackFromEnd = stackFromEnd,
                    type = type
                )
            )
        )
    }

}