package com.amity.socialcloud.sdk.chat.domain.channel

import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.chat.data.channel.reader.ChannelReaderRepository
import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase


internal class ChannelComposerUseCase : ComposerUseCase() {

    fun execute(channel: AmityChannel): AmityChannel {
        addAvatar(channel)
        addUnreadCount(channel)
        addUnreadMention(channel)
        return channel
    }

    private fun addAvatar(channel: AmityChannel) {
        channel.avatarFileId
            ?.let { ImageGetUseCase().execute(it) }
            ?.let { channel.avatar = it }
    }

    private fun addUnreadCount(channel: AmityChannel) {
        channel.unreadCount = ChannelReaderRepository().getUnreadCount(channel.getChannelId())
    }

    private fun addUnreadMention(channel: AmityChannel) {
        channel.hasUnreadMention = ChannelReaderRepository().hasUnreadMention(channel.getChannelId())
    }

}