package com.amity.socialcloud.sdk.chat.domain.message

import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.amity.socialcloud.sdk.core.data.file.FileRepository
import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.AudioGetUseCase
import com.amity.socialcloud.sdk.core.domain.file.FileGetUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.core.domain.file.VideoGetUseCase
import com.amity.socialcloud.sdk.core.domain.reaction.MyReactionsGetUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.core.mention.AmityMentionee
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.ekoapp.ekosdk.internal.usecase.message.IsMessageFlaggedByMeUseCase


internal class MessageComposerUseCase: ComposerUseCase() {

    fun execute(message: AmityMessage): AmityMessage {
        addMyReactions(message)
        addMyFlag(message)
        addUser(message)
        addMentioneeUser(message)
        addFile(message)
        addThumbnailImage(message)
        return message
    }

    private fun addMyReactions(message: AmityMessage) {
        message.myReactions =
            MyReactionsGetUseCase().execute(ReactionReferenceType.MESSAGE, message.getMessageId())
    }

    private fun addMyFlag(message: AmityMessage) {
        message.isFlaggedByMe = IsMessageFlaggedByMeUseCase().execute(message.getMessageId())
    }

    private fun addUser(message: AmityMessage) {
        message.user = UserGetUseCase().execute(message.getUserId())
    }

    private fun addMentioneeUser(message: AmityMessage) {
        message.mentionees = message.getMentionees().map {
            if (it is AmityMentionee.USER) {
                it.user = UserGetUseCase().execute(it.getUserId())
            }
            it
        }
    }

    private fun addFile(message: AmityMessage) {
        message.fileId?.let {
            message.file = when(message.getDataType())  {
                AmityMessage.DataType.IMAGE -> {
                    ImageGetUseCase().execute(it)
                }
                AmityMessage.DataType.FILE-> {
                    FileGetUseCase().execute(it)
                }
                AmityMessage.DataType.AUDIO -> {
                    AudioGetUseCase().execute(it)
                }
                AmityMessage.DataType.VIDEO -> {
                    VideoGetUseCase().execute(it)
                }
                else -> null
            }
        }
    }
    
    private fun addThumbnailImage(message: AmityMessage) {
        message.getThumbnailFileId()?.let {
            message.thumbnailFile = ImageGetUseCase().execute(it)
        }
    }

}