package com.amity.socialcloud.sdk.chat.domain.message

import android.net.Uri
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable

class MessageCreateUseCase {

    fun execute(channelId: String,
                parentId: String?,
                fileUri: Uri?,
                type: String,
                data: JsonObject,
                tags: AmityTags,
                metadata: JsonObject?,
                mentionees: List<AmityMentioneeTarget>): Completable {
        return MessageRepository().createMessage(
            channelId = channelId,
            parentId = parentId,
            type = type,
            fileUri = fileUri,
            data = data,
            tags = tags,
            metadata = metadata,
            mentionees = mentionees
        )
    }

}