package com.amity.socialcloud.sdk.core.data.auth

import com.amity.socialcloud.sdk.AmityEndpoint
import com.amity.socialcloud.sdk.core.error.AmityError
import com.ekoapp.core.utils.toV2
import com.ekoapp.core.utils.toV3
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceRequest
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto
import com.github.davidmoten.rx2.RetryWhen
import io.reactivex.rxjava3.core.Single
import java.util.*
import java.util.concurrent.TimeUnit

internal class TokenRemoteDataStore {

    fun createToken(
        endpoint: AmityEndpoint,
        apiKey: String,
        userId: String,
        displayName: String? = null,
        secureToken: String? = null
    ): Single<RegisterDeviceDto> {
        val deviceId = UUID.randomUUID().toString()
        val request = RegisterDeviceRequest.create(userId, displayName, deviceId, secureToken)
        return TokenApi.token(endpoint)
            .registerDevice(apiKey, request)
            .toV2()
            .retryWhen(
                RetryWhen
                    .retryIf { AmityError.from(it) != AmityError.USER_IS_GLOBAL_BANNED }
                    .maxRetries(3)
                    .exponentialBackoff(1, 10, TimeUnit.SECONDS, 1.5)
                    .build()
            )
            .toV3()
    }

}